/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1.util;

import com.cognos.xqe.data.providers.olap.tm1.TM1MessageKeys;
import com.cognos.xqe.data.providers.olap.tm1.TM1ODPException;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1Metadata;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataSession;
import com.cognos.xqe.data.providers.olap.tm1.metadata.TM1MetadataType;
import com.cognos.xqe.data.providers.olap.tm1.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1AliasTable;
import com.cognos.xqe.data.providers.olap.tm1.util.TM1Constants;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.Dimension;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.Hierarchy;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.SSLConfig;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SimpleTimeZone;
import java.util.regex.Matcher;

public class TM1Utils {
    private static final int MDDS_HUN_NUM_PARTS = 2;
    private static final int MDDS_LUN_NUM_PARTS = 3;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final String MEMBER_TAG = ".[@MEMBER].[";
    private static final char DC1 = '\u0011';

    public static void release(IReleasable releasable) {
        if (releasable != null) {
            releasable.release();
        }
    }

    public static void release(IPooledConnection connection) {
        if (connection != null) {
            connection.returnConnection();
        }
    }

    public static void disposeQuietly(Rowset rowset) {
        if (rowset != null) {
            rowset.dispose();
        }
    }

    public static void disposeQuietly(Cube ... cubes) {
        if (cubes != null) {
            for (Cube cube : cubes) {
                if (cube == null) continue;
                cube.dispose();
            }
        }
    }

    public static void disposeQuietly(Dimension dimension) {
        if (dimension != null) {
            dimension.dispose();
        }
    }

    public static void disposeQuietly(Dimension ... dimensions) {
        if (dimensions != null) {
            for (Dimension dimension : dimensions) {
                TM1Utils.disposeQuietly(dimension);
            }
        }
    }

    public static void disposeQuietly(Hierarchy hierarchy) {
        if (hierarchy != null) {
            hierarchy.dispose();
        }
    }

    public static void disposeQuietly(SSLConfig peer) {
        if (peer != null) {
            peer.dispose();
        }
    }

    public static TimestampValue getTimestampValue(Date date) {
        TimestampValue value = DataValueFactory.createTimestampValue();
        SimpleTimeZone tz = new SimpleTimeZone(0, "UTC");
        GregorianCalendar calendar = new GregorianCalendar(tz);
        calendar.setTime(date);
        value.set((Calendar)calendar);
        return value;
    }

    public static String joinUniqueNames(String uname1, String uname2) {
        StringBuilder buf = new StringBuilder(uname1.length() + uname2.length() + 1);
        buf.append(uname1).append('.').append(uname2);
        return buf.toString();
    }

    public static String convertMDDSHUNToProviderHUN(String mddsHUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsHUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length != 2) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid MDDS HUN: " + mddsHUN);
        }
        return UniqueNameGenerator.createUniqueName((String)parts[1]);
    }

    public static String convertMDDSLUNToProviderLUN(String mddsLUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsLUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length != 3) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid MDDS LUN: " + mddsLUN);
        }
        return UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[2]);
    }

    public static String convertProviderLUNToMDDSLUN(String providerLUN, String mddsHUN) {
        String[] lunParts;
        try {
            lunParts = UniqueNameParser.parse((String)providerLUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (lunParts.length != 2) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid Provider LUN: " + providerLUN);
        }
        return TM1Utils.joinUniqueNames(mddsHUN, UniqueNameGenerator.createSingleNamePart((String)lunParts[1]));
    }

    public static String createCommonMUNPrefix(String providerDUN, String providerHUN) {
        StringBuilder buf = new StringBuilder(providerDUN.length() + providerHUN.length() + MEMBER_TAG.length());
        buf.append(providerDUN).append('.').append(providerHUN).append(MEMBER_TAG);
        return buf.toString();
    }

    public static String createCommonMUNPrefix(IDimension modelDim) {
        IHierarchy modelHier = modelDim.getDefaultHierarchy();
        StringBuilder buf = new StringBuilder(modelHier.getUniqueName().length() + MEMBER_TAG.length());
        buf.append(modelHier.getUniqueName()).append(MEMBER_TAG);
        return buf.toString();
    }

    public static String ceateProviderMUN(String providerHUN, String uniqueNameComponent) {
        StringBuilder buf = new StringBuilder(providerHUN.length() + uniqueNameComponent.length() + 3);
        buf.append(providerHUN).append(".[").append(uniqueNameComponent).append(']');
        return buf.toString();
    }

    public static String createMDDSMUN(String munPrefix, String uniqueNameComponent) {
        StringBuilder buf = new StringBuilder(munPrefix.length() + uniqueNameComponent.length() + 1);
        buf.append(munPrefix).append(uniqueNameComponent).append(']');
        return buf.toString();
    }

    public static String convertProviderMUNToMDDSMUN(String munPrefix, String providerMUN) {
        String component;
        if (!providerMUN.isEmpty()) {
            int dot = providerMUN.indexOf(46);
            if (dot == providerMUN.lastIndexOf(46)) {
                component = providerMUN.substring(dot + 2, providerMUN.length() - 1);
            } else {
                String[] parts;
                try {
                    parts = UniqueNameParser.parse((String)providerMUN);
                }
                catch (UniqueNameParserException ex) {
                    throw XQERuntimeException.wrap((Throwable)ex);
                }
                if (parts.length != 2) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid Provider MUN: " + providerMUN);
                }
                component = UniqueNameParser.escapeSquareBrackets((String)parts[1]);
            }
        } else {
            component = "";
        }
        StringBuilder buf = new StringBuilder(munPrefix.length() + component.length() + 1);
        buf.append(munPrefix).append(component).append(']');
        return buf.toString();
    }

    public static String convertMDDSMUNToProviderMUN(String mddsMUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsMUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length != 4) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid MDDS MUN: " + mddsMUN);
        }
        return TM1Utils.ceateProviderMUN(UniqueNameGenerator.createSingleNamePart((String)parts[1]), UniqueNameParser.escapeSquareBrackets((String)parts[3]));
    }

    public static String extractProviderDUNFromMDDSMUN(String mddsMUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsMUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        return UniqueNameGenerator.createSingleNamePart((String)parts[0]);
    }

    public static String extractProviderHUNFromMDDSMUN(String mddsMUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsMUN);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        return UniqueNameGenerator.createSingleNamePart((String)parts[1]);
    }

    public static String extractMDDSHUNFromMDDSLUN(String mddsLUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsLUN, (int)2);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        return UniqueNameGenerator.createUniqueName((String[])parts);
    }

    public static String extractLastUniqueNamePart(String uniqueName) {
        try {
            return UniqueNameParser.parseLastIdentifier((String)uniqueName);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
    }

    public static String createMDDSPUN(TM1Dimension dimension, String property) {
        return TM1Utils.joinUniqueNames(dimension.getUniqueName(), UniqueNameGenerator.createSingleNamePart((String)property));
    }

    public static String createMDDSPUN(TM1Hierarchy hierarchy, String property) {
        return TM1Utils.joinUniqueNames(hierarchy.getUniqueName(), UniqueNameGenerator.createSingleNamePart((String)property));
    }

    public static String createMDDSPUN(TM1Level level, String property) {
        return TM1Utils.joinUniqueNames(level.getUniqueName(), UniqueNameGenerator.createSingleNamePart((String)property));
    }

    public static TM1Attribute findAttribute(TM1Cube cube, String pun) {
        TM1Level level;
        TM1Hierarchy hierarchy;
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)pun);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (parts.length < 2 || parts.length > 4) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid PUN: " + pun);
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension || dimension.isMeasureDimension()) {
            return null;
        }
        if (parts.length > 2) {
            String providerHUN = UniqueNameGenerator.createSingleNamePart((String)parts[1]);
            hierarchy = dimension.findHierarchy(providerHUN);
            if (null == hierarchy) {
                return null;
            }
        } else {
            return dimension.findAttribute(parts[1]);
        }
        if (parts.length > 3) {
            if (hierarchy.isParentChild()) {
                level = null;
            } else {
                String providerLUN = UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[2]);
                level = hierarchy.findLevel(providerLUN);
            }
            if (null == level) {
                return null;
            }
        } else {
            return hierarchy.findAttribute(parts[2]);
        }
        return level.findAttribute(parts[3]);
    }

    public static TM1Metadata findMetadata(TM1MetadataSession metadataSession, TM1Cube cube, String mddsUniqueName) throws TM1Exception {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsUniqueName);
        }
        catch (UniqueNameParserException ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
        if (0 == parts.length || parts.length > 4) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Invalid unique name format: " + mddsUniqueName);
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension) {
            return null;
        }
        if (1 == parts.length) {
            return dimension;
        }
        String providerHUN = UniqueNameGenerator.createSingleNamePart((String)parts[1]);
        TM1Hierarchy hierarchy = dimension.findHierarchy(providerHUN);
        if (null == hierarchy) {
            return null;
        }
        if (2 == parts.length) {
            return hierarchy;
        }
        if (3 == parts.length) {
            Matcher pcLevelNameMatcher = TM1Constants.PC_LEVEL_NAME_PATTERN.matcher(mddsUniqueName);
            if (pcLevelNameMatcher.find()) {
                int levelNumber = Integer.parseInt(pcLevelNameMatcher.group(1));
                return hierarchy.findLevel(levelNumber);
            }
            String providerLUN = UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[2]);
            return hierarchy.findLevel(providerLUN);
        }
        String providerMUN = TM1Utils.ceateProviderMUN(providerHUN, parts[3]);
        return metadataSession.getLoader().loadSingleMember(hierarchy, providerMUN, MetadataQuery.EMPTY_PROPERTY_ARRAY);
    }

    public static TM1Dimension findDimension(TM1Cube cube, String mddsDUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(null, cube, mddsDUN);
        if (null == metadata || TM1MetadataType.DIMENSION != metadata.getType()) {
            if (mustResolve) {
                throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_DIMENSION, mddsDUN);
            }
            return null;
        }
        return (TM1Dimension)metadata;
    }

    public static TM1Hierarchy findHierarchy(TM1Cube cube, String mddsHUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(null, cube, mddsHUN);
        if (null == metadata || TM1MetadataType.HIERARCHY != metadata.getType()) {
            if (mustResolve) {
                throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_HIERARCHY, mddsHUN);
            }
            return null;
        }
        return (TM1Hierarchy)metadata;
    }

    public static TM1Level findLevel(TM1Cube cube, String mddsLUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(null, cube, mddsLUN);
        if (null == metadata || TM1MetadataType.LEVEL != metadata.getType()) {
            if (mustResolve) {
                throw new TM1ODPException(TM1MessageKeys.MET_NONEXISTANT_LEVEL, mddsLUN);
            }
            return null;
        }
        return (TM1Level)metadata;
    }

    public static TM1Member findMember(TM1MetadataSession session, TM1Cube cube, String mddsMUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(session, cube, mddsMUN);
        if (null == metadata || TM1MetadataType.MEMBER != metadata.getType()) {
            if (mustResolve) {
                throw new TM1ODPException(TM1MessageKeys.MET_INVALID_UNIQUE_NAME, mddsMUN);
            }
            return null;
        }
        return (TM1Member)metadata;
    }

    public static IDataType convertFieldTypeToDataType(FieldType fieldType) {
        switch (fieldType) {
            case Boolean: {
                return DataTypeFactory.getBooleanType();
            }
            case Double: {
                return DataTypeFactory.getDoubleType();
            }
            case Integer: {
                return DataTypeFactory.getLongType();
            }
        }
        return DataTypeFactory.getStringType();
    }

    public static LocalizedString buildLocalizedCaption(Locale defaultLocale, String defaultCaption, TM1AliasTable aliasTable, String dimensionName, Map<String, String> aliasValues) {
        String value;
        String attributeName;
        String defaultLocaleLanguageStr;
        String defaultLocaleStr = LocaleConverter.localeToStr((Locale)defaultLocale);
        if (null == aliasTable) {
            return new LocalizedString(defaultLocale, defaultCaption);
        }
        LocalizedString caption = null;
        Set<String> availableLocals = aliasTable.getLocals(dimensionName);
        if (availableLocals.contains(defaultLocaleLanguageStr = LocaleConverter.getLanguage((Locale)defaultLocale)) && null != (attributeName = aliasTable.getAttributeName(dimensionName, defaultLocaleLanguageStr)) && null != (value = aliasValues.get(attributeName)) && !value.isEmpty()) {
            caption = new LocalizedString(defaultLocale, value);
        }
        if (null == caption) {
            caption = new LocalizedString(defaultLocale, defaultCaption);
        }
        for (String localeStr : availableLocals) {
            String attributeName2;
            if (localeStr.equals(defaultLocaleLanguageStr) || null == (attributeName2 = aliasTable.getAttributeName(dimensionName, localeStr))) continue;
            String value2 = aliasValues.get(attributeName2);
            if (null != value2 && !value2.isEmpty()) {
                caption.put(localeStr, value2);
                continue;
            }
            if (null == value2) continue;
            caption.put(localeStr, defaultCaption);
        }
        return caption;
    }

    public static boolean isNullString(String value) {
        if (null == value) {
            return true;
        }
        if (value.length() != 2) {
            return false;
        }
        return value.charAt(0) == '\u0011' && value.charAt(1) == 'n';
    }

    public static boolean isEmptyString(String value) {
        if (null == value) {
            return false;
        }
        return value.length() == 0;
    }

    public static boolean isErrorString(String value) {
        if (null == value) {
            return false;
        }
        if (value.length() != 2) {
            return false;
        }
        return value.charAt(0) == '\u0011' && value.charAt(1) == 'e';
    }

    public static boolean isDivZeroString(String value) {
        if (null == value) {
            return false;
        }
        if (value.length() != 2) {
            return false;
        }
        return value.charAt(0) == '\u0011' && value.charAt(1) == 'd';
    }

    public static boolean isZeroNumberString(String value) {
        if (null == value) {
            return false;
        }
        if (value.length() != 2) {
            return false;
        }
        return value.charAt(0) == '\u0011' && value.charAt(1) == 'z';
    }
}

