/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.rs;

import com.ibm.ba.gemini.commons.api.ContentEntity;
import com.ibm.ba.gemini.commons.rs.CacheControlDirective;
import com.ibm.ba.gemini.commons.rs.ContentEntityBuilder;
import com.ibm.ba.gemini.commons.rs.EntityBuilder;
import com.ibm.ba.gemini.commons.rs.SimpleEntityBuilder;
import java.io.Closeable;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

@ApplicationScoped
@Default
public class ResponseBuilderFactory {
    ResponseBuilderFactory() {
    }

    public Response.ResponseBuilder create(Request request, String entityTagValue, EntityBuilder entityBuilder, CacheControlDirective ... cacheControlDirectives) {
        return this.create(request, new EntityTag(entityTagValue), entityBuilder, cacheControlDirectives);
    }

    public Response.ResponseBuilder create(Request request, String entityTagValue, Object entity, CacheControlDirective ... cacheControlDirectives) {
        return this.create(request, new EntityTag(entityTagValue), entity, cacheControlDirectives);
    }

    public Response.ResponseBuilder create(Request request, EntityTag entityTag, Object entity, CacheControlDirective ... cacheControlDirectives) {
        EntityBuilder entityBuilder = entity instanceof ContentEntity ? new ContentEntityBuilder((ContentEntity)entity) : new SimpleEntityBuilder(entity);
        return this.create(request, entityTag, entityBuilder, cacheControlDirectives);
    }

    public Response.ResponseBuilder create(Request request, EntityTag entityTag, EntityBuilder entityBuilder, CacheControlDirective ... cacheControlDirectives) {
        Response.ResponseBuilder builder = request.evaluatePreconditions(entityTag);
        if (builder == null) {
            builder = Response.ok((Object)entityBuilder.build()).lastModified(new Date(entityBuilder.getLastModified())).header("expires", (Object)"-1");
        } else {
            this.closeIfPossible(entityBuilder);
        }
        CacheControl cc = new CacheControl();
        cc.setMustRevalidate(true);
        if (cacheControlDirectives != null) {
            this.configureCacheControl(cc, cacheControlDirectives);
        }
        return builder.cacheControl(cc).tag(entityTag);
    }

    private void closeIfPossible(EntityBuilder entityBuilder) {
        if (entityBuilder instanceof Closeable) {
            IOUtils.closeQuietly((Closeable)((Closeable)((Object)entityBuilder)));
        }
    }

    void configureCacheControl(CacheControl cc, CacheControlDirective ... cacheControlDirectives) {
        block8: for (CacheControlDirective cacheControlDirective : cacheControlDirectives) {
            switch (cacheControlDirective) {
                case PRIVATE: {
                    cc.setPrivate(true);
                    continue block8;
                }
                case MUST_REVALIDATE: {
                    cc.setMustRevalidate(true);
                    continue block8;
                }
                case NO_CACHE: {
                    cc.setNoCache(true);
                    continue block8;
                }
                case NO_STORE: {
                    cc.setNoStore(true);
                    continue block8;
                }
                case ALLOW_TRANSFORM: {
                    cc.setNoTransform(false);
                    continue block8;
                }
                case PROXY_REVALIDATE: {
                    cc.setProxyRevalidate(true);
                    continue block8;
                }
            }
        }
    }
}

