/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.rs.binding;

import com.ibm.ba.gemini.commons.api.ContentEntity;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;

@Provider
public class ContentEntityMessageWriter
implements MessageBodyWriter<ContentEntity> {
    ContentEntityMessageWriter() {
    }

    public long getSize(ContentEntity entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return entity.getContentLength();
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ContentEntity.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(ContentEntity entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        InputStream entityContent = null;
        try {
            this.updateHeaders(entity, httpHeaders);
            entityContent = entity.getContentStream();
            IOUtils.copy((InputStream)entityContent, (OutputStream)entityStream);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(entityContent);
            IOUtils.closeQuietly((Closeable)entity);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)entityContent);
        IOUtils.closeQuietly((Closeable)entity);
    }

    void updateHeaders(ContentEntity entity, MultivaluedMap<String, Object> httpHeaders) {
        this.addHeaderIfAbsent(httpHeaders, "Last-Modified", new Date(entity.getLastModified()));
        this.addHeaderIfAbsent(httpHeaders, "Content-Type", entity.getContentType());
    }

    void addHeaderIfAbsent(MultivaluedMap<String, Object> httpHeaders, String headerName, Object value) {
        if (!httpHeaders.containsKey((Object)headerName)) {
            httpHeaders.putSingle((Object)headerName, value);
        }
    }
}

