/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.rs.binding;

import com.ibm.ba.gemini.commons.api.GeminiServiceException;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.helpers.MessageFormatter;

@Provider
public class GeminiServiceExceptionMapper
implements ExceptionMapper<GeminiServiceException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GeminiServiceExceptionMapper.class);
    private static final String LOG_MESSAGE = " Service Exception - Status Code: {}.";
    public static final String STATUS_CODE = "statusCode";
    public static final String ERROR_MSG = "error";
    @Context
    private ServletContext servletContext;

    GeminiServiceExceptionMapper() {
    }

    GeminiServiceExceptionMapper(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public Response toResponse(GeminiServiceException cause) {
        String errorMsg = this.buildErrorMessage(cause);
        if (cause.getStatusCode() >= 500) {
            LOGGER.error(errorMsg);
            LOGGER.error(cause.getMessage(), (Throwable)cause);
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info(errorMsg);
            LOGGER.info(cause.getMessage(), (Throwable)cause);
        }
        return Response.status((int)cause.getStatusCode()).type("application/json").entity((Object)this.buildEntity(cause)).build();
    }

    String buildErrorMessage(GeminiServiceException cause) {
        String errorMsg = MessageFormatter.arrayFormat((String)"Cause: '{}' - StatusCode: '{}' - Context: '{}' ", (Object[])new Object[]{cause.getMessage(), cause.getStatusCode(), MDC.getCopyOfContextMap()}).getMessage();
        return errorMsg;
    }

    private JSONObject buildEntity(GeminiServiceException exception) {
        JSONObject entity = new JSONObject();
        try {
            entity.put(STATUS_CODE, exception.getStatusCode());
            entity.put(ERROR_MSG, (Object)exception.getLocalizedMessage());
        }
        catch (JSONException e) {
            LOGGER.error("An error ocurred while an error response was being created.", (Throwable)e);
        }
        return entity;
    }
}

