/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.rs.binding;

import com.ibm.ba.gemini.commons.api.GeminiServiceException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.Charsets;
import org.apache.commons.json.JSON;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;

@Provider
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class JsonMessageEntityMarshaller<T extends JSONArtifact>
implements MessageBodyWriter<JSONArtifact>,
MessageBodyReader<T> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONArtifact.class.isAssignableFrom(type);
    }

    public long getSize(JSONArtifact t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(JSONArtifact t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        try {
            t.write((Writer)new OutputStreamWriter(entityStream));
        }
        catch (JSONException e) {
            throw new GeminiServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JSONArtifact.class.isAssignableFrom(type);
    }

    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) {
        InputStreamReader reader = new InputStreamReader(entityStream, Charsets.UTF_8);
        try {
            JSONArtifact object = JSON.parse((Reader)reader);
            if (type.isInstance(object)) {
                return (T)object;
            }
            throw new GeminiServiceException(400, "Invalid request entity format.");
        }
        catch (JSONException e) {
            throw new GeminiServiceException(400, e.getMessage(), (Throwable)e);
        }
    }
}

