/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.rs.binding;

import java.io.Serializable;
import java.security.Principal;
import java.util.Locale;
import javax.enterprise.inject.Produces;
import javax.enterprise.util.Nonbinding;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

class RequestContextProvider
implements Serializable {
    private static final long serialVersionUID = 8257768013586249568L;
    @Context
    private transient HttpServletRequest request;

    RequestContextProvider() {
    }

    RequestContextProvider(HttpServletRequest request) {
        this.request = request;
    }

    @Produces
    Locale getLocale() {
        if (this.request != null) {
            return this.request.getLocale();
        }
        return Locale.getDefault();
    }

    @Produces
    @Nonbinding
    MediaType getMediaType() {
        String mediaType;
        if (this.request != null && (mediaType = this.request.getContentType()) != null) {
            return MediaType.valueOf((String)mediaType);
        }
        return null;
    }

    @Produces
    @Nonbinding
    Principal getUserPrincipal() {
        if (this.request != null) {
            return this.request.getUserPrincipal();
        }
        return null;
    }
}

