/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.rs.mdc;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.WebListener;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;

@WebListener(value="MdcRequestListener")
public class MdcRequestListener
implements ServletRequestListener {
    static final String REQUEST_TENANT = "tenant";
    static final String REQUEST_USER = "user";
    static final String REQUEST_METHOD = "method";
    static final String REQUEST_QUERY = "query";
    static final String REQUEST_URI = "requestUri";
    static final String REQUEST_PROTOCOL = "protocol";
    static final String CONTEXT_PATH = "contextPath";
    static final String ATTRIBUTE_PREFIX = "com.ibm.ba.";
    static final String COMPONENT_VERSION = "ComponentVersion";
    static final String COMPONENT_NAME = "ComponentName";
    static final String BA_SCX_SUBSCRIPTION = "ba-scx-subscription";
    static final String BA_SCX_USER = "userid";
    static final String BA_SCX_TENANT = "tid";
    static final String BA_TRANSACTION_HDR = "ba-transaction";
    static final String[] BA_TAGS = new String[]{"waSessionId", "rootTransactionId", "parentTransactionId", "currentTransactionId"};

    public void requestDestroyed(ServletRequestEvent sre) {
        MDC.clear();
    }

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest request;
        if (sre == null) {
            return;
        }
        ServletContext context = sre.getServletContext();
        if (context != null) {
            this.put(CONTEXT_PATH, context.getContextPath());
            this.put(COMPONENT_NAME, (String)context.getAttribute("com.ibm.ba.ComponentName"));
            this.put(COMPONENT_VERSION, (String)context.getAttribute("com.ibm.ba.ComponentVersion"));
        }
        if ((request = sre.getServletRequest()) != null) {
            this.put(REQUEST_PROTOCOL, request.getProtocol());
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                this.put(REQUEST_URI, httpRequest.getRequestURI());
                this.put(REQUEST_QUERY, httpRequest.getQueryString());
                this.put(REQUEST_METHOD, httpRequest.getMethod());
                String scxSubscription = this.getHeaderQuietly(httpRequest, BA_SCX_SUBSCRIPTION);
                Map<String, String> userValues = this.parseHeader(scxSubscription);
                this.put(REQUEST_TENANT, userValues.get(BA_SCX_TENANT), "none");
                this.put(REQUEST_USER, userValues.get(BA_SCX_USER), "none");
                String baTransaction = this.getHeaderQuietly(httpRequest, BA_TRANSACTION_HDR);
                Map<String, String> transactionValues = this.parseHeader(baTransaction);
                for (String tag : BA_TAGS) {
                    this.put(tag, transactionValues.get(tag), "none");
                }
            }
        }
    }

    private void put(String key, String value) {
        if (key != null) {
            MDC.put((String)key, (String)String.valueOf(value));
        }
    }

    private void put(String key, String value, String defaultValue) {
        if (key != null) {
            MDC.put((String)key, (String)(StringUtils.isBlank((String)value) ? defaultValue : value));
        }
    }

    private String getHeaderQuietly(HttpServletRequest httpRequest, String name) {
        try {
            String hdrValue = httpRequest.getHeader(name);
            if (!StringUtils.isEmpty((String)hdrValue)) {
                return URLDecoder.decode(hdrValue, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "";
    }

    private Map<String, String> parseHeader(String scxHeader) {
        String[] pairs;
        if (StringUtils.isEmpty((String)scxHeader)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pair : pairs = StringUtils.split((String)scxHeader, (char)';')) {
            String[] nameVal = StringUtils.split((String)pair, (char)'=');
            if (ArrayUtils.getLength((Object)nameVal) != 2) continue;
            String key = StringUtils.trim((String)nameVal[0]);
            String val = StringUtils.trim((String)nameVal[1]);
            if (StringUtils.isBlank((String)key) || StringUtils.isBlank((String)val)) continue;
            map.put(key, val);
        }
        return map;
    }
}

