/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client;

import com.ibm.ba.flint.client.aop.AdviceProxyBuilder;
import com.ibm.ba.flint.client.util.ThreadLocalContextProvider;
import com.ibm.icu.text.Collator;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class ServiceDecorations {
    public static final String PROP_REQUEST_PRIORITY = "request.priority";
    public static final String PROP_REQUEST_TIMEOUT_SECONDS = "request.timeoutSeconds";
    public static final String PROP_COLLATOR_LOCALE = "collator.locale";
    public static final String PROP_COLLATOR_STENGTH = "collator.strength";
    public static final String PROP_COLLATOR_DECOMPOSITION = "collator.decomposition";

    private ServiceDecorations() {
    }

    public static <T> T lowPriority(T service, Class<T> iface) {
        return ServiceDecorations.withContextualProp(service, iface, PROP_REQUEST_PRIORITY, "low");
    }

    public static <T> T highPriority(T service, Class<T> iface) {
        return ServiceDecorations.withContextualProp(service, iface, PROP_REQUEST_PRIORITY, "high");
    }

    public static <T> T timeoutSeconds(T service, Class<T> iface, int timeoutSeconds) {
        return ServiceDecorations.withContextualProp(service, iface, PROP_REQUEST_TIMEOUT_SECONDS, Integer.toString(timeoutSeconds));
    }

    public static <T> T collator(T service, Class<T> iface, Collator collator) {
        Objects.requireNonNull(collator, "collator must not be null");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(PROP_COLLATOR_LOCALE, collator.getLocale(ULocale.ACTUAL_LOCALE).toString());
        props.put(PROP_COLLATOR_STENGTH, Integer.toString(collator.getStrength()));
        props.put(PROP_COLLATOR_DECOMPOSITION, Integer.toString(collator.getDecomposition()));
        return ServiceDecorations.withContextualProps(service, iface, props);
    }

    public static <T> T withContextualProp(T service, Class<T> iface, String key, String value) {
        HashMap<String, String> props = new HashMap<String, String>(1);
        props.put(key, value);
        return ServiceDecorations.withContextualProps(service, iface, props);
    }

    public static <T> T withContextualProps(T service, Class<T> iface, Map<String, String> props) {
        return new AdviceProxyBuilder(service).setInterfaces(iface).setBeforeAdvice((jp, adviceContext) -> {
            HashMap<String, String> backupContextMap = new HashMap<String, String>(ThreadLocalContextProvider.getContextMap());
            adviceContext.setValue(backupContextMap);
            ThreadLocalContextProvider.getContextMap().putAll(props);
        }).setAfterAdvice((jp, returned, thrown, adviceContext) -> {
            Map backupContextMap = (Map)adviceContext.getValue();
            ThreadLocalContextProvider.getContextMap().clear();
            ThreadLocalContextProvider.getContextMap().putAll(backupContextMap);
        }).build(iface);
    }
}

