/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.flint.client.aop;

import com.ibm.ba.flint.client.aop.AdviceHandler;
import com.ibm.ba.flint.client.aop.AfterAdvice;
import com.ibm.ba.flint.client.aop.BeforeAdvice;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class AdviceProxyBuilder {
    private final Object target;
    private Class<?>[] interfaces = new Class[0];
    private BeforeAdvice before;
    private AfterAdvice after;

    public AdviceProxyBuilder(Object target) {
        if (null == target) {
            throw new NullPointerException("target was null");
        }
        this.target = target;
    }

    public AdviceProxyBuilder setInterfaces(Class<?> ... interfaces) {
        if (null == interfaces) {
            throw new NullPointerException("interfaces was null");
        }
        this.interfaces = interfaces;
        return this;
    }

    public AdviceProxyBuilder setBeforeAdvice(BeforeAdvice before) {
        this.before = before;
        return this;
    }

    public AdviceProxyBuilder setAfterAdvice(AfterAdvice after) {
        this.after = after;
        return this;
    }

    public <T> T build(Class<T> type) {
        if (this.interfaces.length == 0) {
            throw new IllegalStateException("there must be at least one interface defined");
        }
        AdviceHandler handler = new AdviceHandler(this.target).setBefore(this.before).setAfter(this.after);
        return type.cast(Proxy.newProxyInstance(type.getClassLoader(), this.interfaces, (InvocationHandler)handler));
    }
}

