/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1;

import com.ibm.cognos.tm1.SecurityMode;

public enum ESecurityMode {
    TM1_SECURITY_MODE_UNKNOWN(0),
    TM1_SECURITY_MODE_BASIC(1),
    TM1_SECURITY_MODE_MIXED(2),
    TM1_SECURITY_MODE_WIA(3),
    TM1_SECURITY_MODE_CAM(4),
    TM1_SECURITY_MODE_MIXED_CAM(5),
    TM1_SECURITY_MODE_DISTRIBUTED(6);

    private final int tm1ServerValue;

    private ESecurityMode(int theTM1Value) {
        this.tm1ServerValue = theTM1Value;
    }

    public int toTM1Type() {
        return this.tm1ServerValue;
    }

    public boolean hasTM1Security() {
        return this.equals((Object)TM1_SECURITY_MODE_MIXED_CAM) || this.equals((Object)TM1_SECURITY_MODE_CAM) || this.equals((Object)TM1_SECURITY_MODE_WIA) || this.equals((Object)TM1_SECURITY_MODE_MIXED);
    }

    public boolean mightRequireWIA() {
        return this.equals((Object)TM1_SECURITY_MODE_WIA) || this.equals((Object)TM1_SECURITY_MODE_MIXED);
    }

    public boolean isMixedMode() {
        return this.equals((Object)TM1_SECURITY_MODE_MIXED);
    }

    public static ESecurityMode valueOf(int ordinal) {
        for (ESecurityMode e : ESecurityMode.values()) {
            if (e.ordinal() != ordinal) continue;
            return e;
        }
        StringBuffer buffer = new StringBuffer("INVALID_TM1_SECURITY_MODE ");
        buffer.append('(');
        buffer.append(ordinal);
        buffer.append(')');
        throw new IllegalArgumentException(buffer.toString());
    }

    public static ESecurityMode valueOf(SecurityMode tm1SecMode) {
        switch (tm1SecMode) {
            case Basic: {
                return TM1_SECURITY_MODE_BASIC;
            }
            case CAM: {
                return TM1_SECURITY_MODE_CAM;
            }
            case Distributed: {
                return TM1_SECURITY_MODE_DISTRIBUTED;
            }
            case Mixed: {
                return TM1_SECURITY_MODE_MIXED;
            }
            case WIA: {
                return TM1_SECURITY_MODE_WIA;
            }
        }
        return TM1_SECURITY_MODE_UNKNOWN;
    }
}

