/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.pmta_bridge.IPMTAApplication;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1DataProvider;
import com.ibm.cognos.tm1.API;
import com.ibm.cognos.tm1.Server;

public class PMTAConnection
extends TM1Connection {
    public static final String USE_PMTA = "usePMTA";
    public static final String IN_PROCESS = "inProcess";
    public static final String SESSION_ID = "sessionID";
    public static final String URL = "url";
    public static final String DATA_DIR = "dataDir";
    private final IPMTAApplication mApp;

    public PMTAConnection(TM1DataProvider provider, IConnectionSpec connSpec, IPMTAApplication app) {
        super(provider, connSpec, (Server)app.getTM1Server(Server.class));
        this.mApp = app;
    }

    @Override
    public API getAPI() {
        return (API)this.mApp.getTM1API(API.class);
    }

    @Override
    public boolean matches(IConnectionSpec connSpec) {
        IConnectionSpec thisConnSpec = this.getConnectionSpec();
        if (!PMTAConnection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)USE_PMTA)) {
            return false;
        }
        if (!PMTAConnection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)IN_PROCESS)) {
            return false;
        }
        if (!PMTAConnection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)SESSION_ID)) {
            return false;
        }
        if (!PMTAConnection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)URL)) {
            return false;
        }
        if (!PMTAConnection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)"locale")) {
            return false;
        }
        return thisConnSpec.getParameterBooleanValue(IN_PROCESS) == false || PMTAConnection.matchString((IConnectionSpec)thisConnSpec, (IConnectionSpec)connSpec, (String)DATA_DIR);
    }

    @Override
    protected void closeImpl() {
        this.mApp.dispose();
    }
}

