/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.IPhysicalMetadata;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapDimension;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapHierarchy;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapLevel;
import com.ibm.cognos.aurora.api.model.physical.olap.IOlapMemberProperty;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.query.provider.IRestrictions;
import com.ibm.cognos.aurora.api.query.provider.connection.IExpirationPolicy;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionFactory;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionPool;
import com.ibm.cognos.aurora.api.query.provider.dim.ICatalogRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.ICellAccessor;
import com.ibm.cognos.aurora.api.query.provider.dim.ICubeRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalResultSet;
import com.ibm.cognos.aurora.api.query.provider.dim.IHierarchyRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.ILevelRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMDQuery;
import com.ibm.cognos.aurora.api.query.provider.dim.IMeasureRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IPropertyRecord;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.logging.ObjectType;
import com.ibm.cognos.aurora.core.logging.Status;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.model.DataItemStats;
import com.ibm.cognos.aurora.core.util.ConfigHelper;
import com.ibm.cognos.aurora.core.util.LocaleUtil;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.Restrictions;
import com.ibm.cognos.aurora.qls.query.provider.connection.ProviderConnectionPool;
import com.ibm.cognos.aurora.qls.query.provider.connection.SimpleExpirationPolicy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1ConnectionFactory;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CellAccessor;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CubeResultSet;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1MDXQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1ObjectAccessor;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1SSLConfigs;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.API;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.TM1Exception;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class TM1DataProvider
implements IDimensionalDataProvider {
    public static final String PROVIDER_TYPE = "tm1";
    private static final int TM1API_MIN_VERSION = 100100000;
    private static final int REST_MIN_VERSION = 100100000;
    private static final int CONVERT_NULL_CELLS_TO_UNDEF_VALS_MIN_VERSION = 90520003;
    private static final String POOL_NAME = "TM1ConnectionPool";
    private static final long POOL_IDLE_TIME = 300000L;
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");
    private IQueryLogicalStorage mQLS = null;
    private TM1ConnectionFactory mConnFactory;
    private ProviderConnectionPool mConnPool;
    private final AtomicBoolean mDisposed = new AtomicBoolean(false);
    private API mAPI;

    public static boolean isRESTSupported(int version) {
        return version >= 100100000;
    }

    public static boolean isConvertNullCellsToUndefValsSupported(int version) {
        return version >= 90520003;
    }

    public IQueryLogicalStorage getQLS() {
        return this.mQLS;
    }

    public IProviderConnectionFactory getConnectionFactory() {
        return this.mConnFactory;
    }

    public IProviderConnectionPool getConnectionPool() {
        return this.mConnPool;
    }

    public IDataItemStats fetchDataItemStats(IDataItem dataItem) {
        DataItemStats stats = new DataItemStats();
        IPhysicalMetadata md = dataItem.getPhysicalMetadata();
        if (null == md) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)"dataItem has no physical metadata");
        }
        switch (md.getType()) {
            case OLAP_DIMENSION: {
                IOlapDimension dim = (IOlapDimension)md;
                stats.setCount(dim.getCardinality());
                stats.setDistinctCount(dim.getCardinality());
                stats.setDensity(1.0f);
                stats.setNullable(false);
                break;
            }
            case OLAP_HIERARCHY: {
                IOlapHierarchy hier = (IOlapHierarchy)md;
                stats.setCount(hier.getCardinality());
                stats.setDistinctCount(hier.getCardinality());
                stats.setDensity(1.0f);
                stats.setNullable(false);
                break;
            }
            case OLAP_LEVEL: {
                IOlapLevel level = (IOlapLevel)md;
                stats.setCount(level.getCardinality());
                stats.setDistinctCount(level.getCardinality());
                stats.setDensity(1.0f);
                stats.setNullable(false);
                break;
            }
            case OLAP_MEMBER_PROPERTY: {
                IOlapMemberProperty prop = (IOlapMemberProperty)md;
                IOlapLevel level = prop.getLevel();
                stats.setCount(level.getCardinality());
                stats.setDistinctCount(level.getCardinality());
                stats.setDensity(1.0f);
                stats.setNullable(false);
                break;
            }
        }
        return stats;
    }

    @Deprecated
    public IValueIterator fetchDataItemValues(IDataItem dataItem, boolean distinct) {
        return this.fetchDataItemValues(dataItem, distinct, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValueIterator fetchDataItemValues(IDataItem dataItem, boolean distinct, long limit) {
        IPhysicalMetadata md = dataItem.getPhysicalMetadata();
        if (null == md) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)"dataItem has no physical metadata");
        }
        IDataSource ds = md.getModel().getDataSource();
        Restrictions rest = new Restrictions();
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        try {
            switch (md.getType()) {
                case OLAP_DIMENSION: {
                    IOlapDimension dim = (IOlapDimension)md;
                    rest.put((Object)"CATALOG_NAME", (Object)dim.getCube().getCatalogName());
                    rest.put((Object)"CUBE_NAME", (Object)dim.getCube().getName());
                    rest.put((Object)"DIMENSION_UNIQUE_NAME", (Object)dim.getUniqueName());
                    MemberNameIter memberNameIter = new MemberNameIter(this.discoverMembers(ds, (IRestrictions)rest, (IQueryContext)queryContext));
                    return memberNameIter;
                }
                case OLAP_HIERARCHY: {
                    IOlapHierarchy hier = (IOlapHierarchy)md;
                    rest.put((Object)"CATALOG_NAME", (Object)hier.getCube().getCatalogName());
                    rest.put((Object)"CUBE_NAME", (Object)hier.getCube().getName());
                    rest.put((Object)"HIERARCHY_UNIQUE_NAME", (Object)hier.getUniqueName());
                    MemberNameIter memberNameIter = new MemberNameIter(this.discoverMembers(ds, (IRestrictions)rest, (IQueryContext)queryContext));
                    return memberNameIter;
                }
                case OLAP_LEVEL: {
                    IOlapLevel level = (IOlapLevel)md;
                    rest.put((Object)"CATALOG_NAME", (Object)level.getCube().getCatalogName());
                    rest.put((Object)"CUBE_NAME", (Object)level.getCube().getName());
                    if (level.getHierarchy().isParentChild()) {
                        rest.put((Object)"HIERARCHY_UNIQUE_NAME", (Object)level.getHierarchy().getUniqueName());
                        rest.put((Object)"LEVEL_NUMBER", (Object)level.getLevelNumber());
                    } else {
                        rest.put((Object)"LEVEL_UNIQUE_NAME", (Object)level.getUniqueName());
                    }
                    MemberNameIter memberNameIter = new MemberNameIter(this.discoverMembers(ds, (IRestrictions)rest, (IQueryContext)queryContext));
                    return memberNameIter;
                }
                case OLAP_MEMBER_PROPERTY: {
                    IOlapMemberProperty prop = (IOlapMemberProperty)md;
                    IOlapLevel level = prop.getLevel();
                    rest.put((Object)"CATALOG_NAME", (Object)level.getCube().getCatalogName());
                    rest.put((Object)"CUBE_NAME", (Object)level.getCube().getName());
                    if (level.getHierarchy().isParentChild()) {
                        rest.put((Object)"HIERARCHY_UNIQUE_NAME", (Object)level.getHierarchy().getUniqueName());
                        rest.put((Object)"LEVEL_NUMBER", (Object)level.getLevelNumber());
                    } else {
                        rest.put((Object)"LEVEL_UNIQUE_NAME", (Object)level.getUniqueName());
                    }
                    MemberNameIter memberNameIter = new MemberNameIter(this.discoverMembers(ds, (IRestrictions)rest, (IQueryContext)queryContext));
                    return memberNameIter;
                }
            }
            EmptyIterator emptyIterator = EMPTY_ITERATOR;
            return emptyIterator;
        }
        finally {
            queryContext.terminate();
        }
    }

    public long fetchDistinctTupleCount(IDataItem[] dataItems) {
        if (dataItems.length == 0) {
            return 0L;
        }
        long count = 1L;
        for (IDataItem di : dataItems) {
            count *= di.getStats().count();
        }
        return count;
    }

    public void initialize(IQueryLogicalStorage qls, Properties props) throws Exception {
        String ngtm1apiLocation = ConfigHelper.getString((Properties)props, (String)"aurora.qls.tm1.ngtm1api.location", null);
        String sslConfigsLocation = ConfigHelper.getString((Properties)props, (String)"ngtm1api_sslconfigs_path", (String)"../configuration/tm1.sslconfigs.xml");
        PerfLogEvent event = null;
        if (logger.isPerfDebugEnabled()) {
            event = logger.startPerfDebug(this.getClass().getName(), "initialize", "Start initializing TM1DataProvider");
        }
        this.mQLS = qls;
        try {
            if (null != ngtm1apiLocation) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Initializing NGTM1APIS (path=%s, minVersion=%d, sslConfigs=%s)", ngtm1apiLocation, 100100000, sslConfigsLocation), this.getClass().getName() + "::initialize()");
                }
                this.mAPI = API.initialize((String)ngtm1apiLocation, (int)100100000);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Initializing NGTM1APIS (minVersion=%d, sslConfigs=%s)", 100100000, sslConfigsLocation), this.getClass().getName() + "::initialize()");
                }
                this.mAPI = API.initialize((int)100100000);
            }
        }
        catch (TM1Exception ex) {
            logger.error("NGTM1APIS initialization failed", this.getClass().getName() + "::initialize()", (Throwable)ex);
            logger.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.TM1DATAPROVIDER, (Status)Status.FAILURE));
            throw TM1ProviderException.convert(ex);
        }
        File sslConfigsFile = new File(sslConfigsLocation);
        if (sslConfigsFile.exists()) {
            if (logger.isInfoEnabled()) {
                logger.info("Loading TM1 SSL configurations from " + sslConfigsLocation, this.getClass().getName() + "::initialize()");
            }
            try {
                TM1SSLConfigs sslConfigs = new TM1SSLConfigs();
                sslConfigs.loadFile(sslConfigsFile);
                if (logger.isInfoEnabled()) {
                    logger.info(sslConfigs.toString(), this.getClass().getName() + "::initialize()");
                }
                for (String adminHost : sslConfigs.getAdminHosts()) {
                    this.mAPI.setSSLConfig(adminHost, sslConfigs.getSSLConfig(adminHost));
                }
            }
            catch (Exception ex) {
                logger.error("NGTM1APIS SSL configuration failed", this.getClass().getName() + "::initialize()", (Throwable)ex);
                logger.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.TM1DATAPROVIDER, (Status)Status.FAILURE));
                throw ex;
            }
        }
        this.mConnFactory = new TM1ConnectionFactory(this);
        this.mConnPool = new ProviderConnectionPool(POOL_NAME, (IProviderConnectionFactory)this.mConnFactory, (IExpirationPolicy)new SimpleExpirationPolicy(300000L));
        this.mQLS.getConnectionPoolManager().registerPool((IProviderConnectionPool)this.mConnPool);
        logger.auditSystemEvent(LogEventHelper.createStartServiceEvent((ObjectType)ObjectType.TM1DATAPROVIDER, (Status)Status.SUCCESS));
        if (event != null) {
            logger.stopPerfDebug(event, "Finished initializing TM1DataProvider");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.mDisposed.compareAndSet(false, true)) {
            try {
                if (null != this.mConnPool) {
                    this.mQLS.getConnectionPoolManager().unregisterPool((IProviderConnectionPool)this.mConnPool);
                    this.mConnPool.shutdown();
                }
            }
            finally {
                this.mAPI.dispose();
            }
        }
    }

    public List<ICatalogRecord> discoverCatalogs(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<ICatalogRecord> list = session.getCatalogRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<ICubeRecord> discoverCubes(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<ICubeRecord> list = session.getCubeRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getTM1Blob(String blobId, IDataSource dataSource, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1ObjectAccessor objectAccessor = new TM1ObjectAccessor(conn);
            byte[] byArray = objectAccessor.getBlob(blobId);
            return byArray;
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<IDimensionRecord> discoverDimensions(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<IDimensionRecord> list = session.getDimensionRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<IHierarchyRecord> discoverHierarchies(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<IHierarchyRecord> list = session.getHierarchyRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<ILevelRecord> discoverLevels(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<ILevelRecord> list = session.getLevelRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<IMemberRecord> discoverMembers(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<IMemberRecord> list = session.getMemberRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<IMemberRecord> discoverHierarchyRootMembers(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<IMemberRecord> list = session.getHierarchyRootMemberRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<IMeasureRecord> discoverMeasures(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<IMeasureRecord> list = session.getMeasureRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public List<IPropertyRecord> discoverProperties(IDataSource dataSource, IRestrictions restrictions, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession session = new TM1MetadataSession(conn);
            List<IPropertyRecord> list = session.getPropertyRecords(restrictions);
            return list;
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        finally {
            conn.returnToPool();
        }
    }

    public IDimensionalResultSet execute(IMDQuery query, IQueryContext queryContext) {
        IDataSource dataSource = query.getDataSource();
        String cubeName = query.getCubeName();
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, queryContext);
        try {
            TM1MetadataSession mdSession = new TM1MetadataSession(conn);
            TM1Cube cube = mdSession.getLoader().loadCube(cubeName);
            if (null == cube) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)cubeName);
            }
            String queryString = TM1DataProvider.buildQueryString(query, cube, TM1Utils.resolveProductLocale(queryContext), conn.getServer().getVersion(), false);
            TM1MDXQuery tm1Query = new TM1MDXQuery(conn, queryContext);
            int[] axisLimits = queryContext.getAxisTupleLimits();
            if (axisLimits != null) {
                long[] partitions = new long[axisLimits.length];
                for (int i = 0; i < partitions.length; ++i) {
                    partitions[i] = axisLimits[i];
                }
                tm1Query.setPartitions(partitions);
            }
            Cellset cellset = tm1Query.execute(queryString);
            return new TM1CubeResultSet(this, mdSession.getLoader(), cube, conn, queryContext, query.getExpectedEdgeCount(), cellset, true);
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::execute()");
            conn.returnToPool();
            throw TM1ProviderException.convert(ex);
        }
        catch (RuntimeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::execute()");
            conn.returnToPool();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataSource(IDataSource dataSource) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, null);
        try {
            conn.validate();
        }
        finally {
            conn.returnToPool();
        }
    }

    public ICellAccessor openCellAccessor(IDataSource dataSource, String catalogName, String cubeName, IQueryContext queryContext) {
        IConnectionSpec connSpec = dataSource.getConnectionSpec();
        TM1Connection conn = this.borrowConnection(connSpec, null);
        try {
            TM1MetadataSession mdSession = new TM1MetadataSession(conn);
            TM1Cube tm1Cube = mdSession.getLoader().loadCube(cubeName);
            if (null == tm1Cube) {
                throw new TM1ProviderException(TM1MessageKeys.MET_CubeNotFound, cubeName);
            }
            return new TM1CellAccessor(this, mdSession.getLoader(), tm1Cube, conn, queryContext);
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::openCellAccessor()");
            conn.returnToPool();
            throw TM1ProviderException.convert(ex);
        }
        catch (RuntimeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::openCellAccessor()");
            conn.returnToPool();
            throw ex;
        }
    }

    private TM1Connection borrowConnection(IConnectionSpec connSpec, IQueryContext queryCtx) {
        if (!connSpec.containsParameter("locale")) {
            Locale contextLocale = null;
            if (null != queryCtx) {
                contextLocale = queryCtx.getContentLocale();
            }
            if (null == contextLocale && null != LocalSessionContext.get()) {
                contextLocale = LocalSessionContext.get().getContentLocale();
            }
            if (null != contextLocale) {
                IConnectionSpec newConnSpec = connSpec.duplicate();
                newConnSpec.setParameterValue("locale", (Object)LocaleUtil.localeToString((Locale)contextLocale));
                return (TM1Connection)this.getConnectionPool().borrow(newConnSpec);
            }
        }
        return (TM1Connection)this.getConnectionPool().borrow(connSpec);
    }

    protected static String buildQueryString(IMDQuery mdQuery, TM1Cube cube, Locale productLocale, int serverVersion, boolean forLogging) {
        StringBuilder queryString = new StringBuilder();
        if (mdQuery.isMDQuerySpec()) {
            queryString.append("CognosMDXClient: ");
        } else if (mdQuery.isBluenose()) {
            queryString.append("UseCognosMDXEngine: ");
        }
        if (mdQuery.isMDQuerySpec()) {
            String productLocaleStr = productLocale.toString();
            queryString.append(String.format("<execute productLocale=\"%s\">", productLocaleStr));
        }
        String executeQuery = mdQuery.getQueryString();
        if (mdQuery.isMDQuerySpec()) {
            executeQuery = executeQuery.replaceAll("<suppress>\\s*<suppressNone/>\\s*</suppress>\\s*", "");
        }
        queryString.append(executeQuery);
        if (mdQuery.isMDQuerySpec()) {
            if (mdQuery.getIncludeCalculatedMembers()) {
                queryString.append("<includeCalculatedMembers value=\"true\"/>");
            }
            if (mdQuery.getNullExpressionBehavior() != null) {
                queryString.append("<");
                queryString.append("nullExpressionBehavior");
                queryString.append(" value=");
                queryString.append("\"");
                queryString.append(mdQuery.getNullExpressionBehavior());
                queryString.append("\"");
                queryString.append("/");
                queryString.append(">");
            }
            if (mdQuery.getNullSuppressionQueryHint() != null) {
                queryString.append("<");
                queryString.append("nullSuppressionAcrossEdges");
                queryString.append(" value=");
                queryString.append("\"");
                queryString.append(mdQuery.getNullSuppressionQueryHint());
                queryString.append("\"");
                queryString.append("/");
                queryString.append(">");
            }
            if (mdQuery.isPXJEnabled()) {
                queryString.append("<");
                queryString.append("UseProviderCrossJoinThreshold");
                queryString.append(" value=");
                queryString.append("\"");
                queryString.append("1000");
                queryString.append("\"");
                queryString.append("/");
                queryString.append(">");
            }
            if (TM1DataProvider.isConvertNullCellsToUndefValsSupported(serverVersion)) {
                queryString.append("<");
                queryString.append("ConvertNullCellsToUndefVals");
                queryString.append(" value=");
                queryString.append("\"");
                queryString.append("false");
                queryString.append("\"");
                queryString.append("/");
                queryString.append(">");
            }
            queryString.append("</execute>");
        }
        return queryString.toString();
    }

    protected API getAPI() {
        return this.mAPI;
    }

    private static final class MemberNameIter
    implements IValueIterator {
        private final List<IMemberRecord> mRecords;
        private Iterator<IMemberRecord> mRecordIter;

        MemberNameIter(List<IMemberRecord> records) {
            this.mRecords = records;
            this.mRecordIter = this.mRecords.iterator();
        }

        public boolean hasNext() {
            return this.mRecordIter.hasNext();
        }

        public IValue next() {
            IMemberRecord rec = this.mRecordIter.next();
            if (null == rec) {
                return null;
            }
            return ValueFactory.createString((String)rec.getName());
        }

        public void reset() {
            this.mRecordIter = this.mRecords.iterator();
        }

        public void close() {
        }
    }

    private static final class EmptyIterator
    implements IValueIterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public IValue next() {
            return null;
        }

        public void reset() {
        }

        public void close() {
        }
    }
}

