/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.data.IDataPointIterator;
import com.ibm.cognos.aurora.api.query.provider.dim.ICellAccessor;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1DataProvider;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CubeResultSet;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataLoader;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1CellAccessor
implements ICellAccessor {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");
    private final TM1DataProvider mProvider;
    private final TM1MetadataLoader mMetadataLoader;
    private final TM1Cube mTM1Cube;
    private final Cube mAPICube;
    private final TM1Connection mConnection;
    private final IQueryContext mQueryContext;
    private boolean mReserved = false;
    private volatile boolean mDisposed = false;

    public TM1CellAccessor(TM1DataProvider provider, TM1MetadataLoader metadataLoader, TM1Cube tm1Cube, TM1Connection connection, IQueryContext queryContext) {
        this.mProvider = provider;
        this.mMetadataLoader = metadataLoader;
        this.mTM1Cube = tm1Cube;
        this.mConnection = connection;
        this.mQueryContext = queryContext;
        try {
            this.mAPICube = connection.getServer().findCube(tm1Cube.getName());
            if (null == this.mAPICube) {
                throw new TM1ProviderException(TM1MessageKeys.MET_CubeNotFound, this.mTM1Cube.getName());
            }
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::TM1CellAccessor()");
            throw TM1ProviderException.convert(ex);
        }
    }

    public String getCatalogName() {
        return "CATALOG";
    }

    public String getCubeName() {
        return this.mTM1Cube.getName();
    }

    public boolean isWriteEnabled() {
        try {
            return this.mAPICube.isWriteEnabled();
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::isWriteEnabled()");
            throw TM1ProviderException.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public IValue getCell(String[] cellMembers) {
        String[] providerMUNs = TM1CellAccessor.convertToProviderMUNs(cellMembers);
        try {
            TM1CubeResultSet rs = new TM1CubeResultSet(this.mProvider, this.mMetadataLoader, this.mTM1Cube, this.mConnection, this.mQueryContext, 1, this.mAPICube.getCell(providerMUNs), false);
            try {
                IDataPointIterator iter;
                block10: {
                    IValue iValue;
                    iter = rs.getCellIterator();
                    try {
                        if (!iter.hasNext()) break block10;
                        iValue = iter.next().getValue();
                    }
                    catch (Throwable throwable) {
                        iter.close();
                        throw throwable;
                    }
                    iter.close();
                    return iValue;
                }
                IValue iValue = ValueFactory.create(null);
                iter.close();
                return iValue;
            }
            finally {
                rs.close();
            }
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::getCell()");
            throw TM1ProviderException.convert(ex);
        }
    }

    public void updateCell(String[] cellMembers, double dValue) {
        String[] providerMUNs = TM1CellAccessor.convertToProviderMUNs(cellMembers);
        try {
            this.mAPICube.updateCell(providerMUNs, dValue);
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::updateCell()");
            throw TM1ProviderException.convert(ex);
        }
    }

    public void updateCell(String[] cellMembers, String sValue) {
        String[] providerMUNs = TM1CellAccessor.convertToProviderMUNs(cellMembers);
        try {
            this.mAPICube.updateCell(providerMUNs, sValue);
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::updateCell()");
            throw TM1ProviderException.convert(ex);
        }
    }

    public void reserve() {
        try {
            this.mAPICube.reserve();
            this.mReserved = true;
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::reserve()");
            throw TM1ProviderException.convert(ex);
        }
    }

    public void release() {
        try {
            this.mAPICube.release();
            this.mReserved = false;
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::release()");
            throw TM1ProviderException.convert(ex);
        }
    }

    public void saveChanges() {
        try {
            this.mAPICube.saveChanges();
        }
        catch (TM1Exception ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::saveChanges()");
            throw TM1ProviderException.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        this.mDisposed = true;
        try {
            if (this.mReserved) {
                this.release();
            }
        }
        finally {
            this.mAPICube.dispose();
            this.mConnection.returnToPool();
        }
    }

    private static String[] convertToProviderMUNs(String[] mddsMUNs) {
        String[] providerMUNs = new String[mddsMUNs.length];
        for (int i = 0; i < mddsMUNs.length; ++i) {
            providerMUNs[i] = TM1Utils.convertMDDSMUNToProviderMUN(mddsMUNs[i]);
        }
        return providerMUNs;
    }
}

