/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.format.IValueFormat;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.OperationCanceledException;
import com.ibm.cognos.aurora.api.query.data.IDataPoint;
import com.ibm.cognos.aurora.api.query.data.IDataPointIterator;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.query.data.DataPoint;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CellsetFields;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CubeResultSet;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1RowsetAccessor;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.qls.format.QLSFormatService;
import com.ibm.cognos.tm1.CellStatus;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.icu.util.TimeZone;
import java.util.Date;

public class TM1CellIterator
implements IDataPointIterator {
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");
    private final TM1CubeResultSet mResultSet;
    private final Cellset mCellset;
    private final ITM1RowsetView<TM1CellsetFields> mAccessor;
    private boolean mHasNext = false;
    private DataPoint mNextCell = null;
    private long mNextOrdinal = -1L;
    private volatile boolean mClosed = false;

    public TM1CellIterator(TM1CubeResultSet rs, Cellset cellset) throws TM1Exception {
        this.mResultSet = rs;
        this.mCellset = cellset;
        this.mCellset.reset();
        this.mAccessor = TM1RowsetAccessor.create((Rowset)this.mCellset, TM1CellsetFields.class);
        this.fetchNextCell();
    }

    private boolean fetchNextCell() throws TM1Exception {
        if (this.mResultSet.getQueryContext().isCanceled()) {
            throw new OperationCanceledException();
        }
        IQueryContext queryCtx = this.mResultSet.getQueryContext();
        this.mHasNext = false;
        this.mNextCell = null;
        while (this.mCellset.getNext()) {
            if (queryCtx.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.mNextOrdinal = this.mAccessor.containsField(TM1CellsetFields.CELL_ORDINAL) ? this.mAccessor.getIntegerField(TM1CellsetFields.CELL_ORDINAL) : ++this.mNextOrdinal;
            CellStatus status = this.mCellset.getCellStatus();
            if (CellStatus.Null == status) continue;
            String formatString = null;
            StringValue value = null;
            boolean isNull = false;
            boolean isError = false;
            boolean isDivByZero = false;
            if (CellStatus.Data == status) {
                if (this.mAccessor.containsField(TM1CellsetFields.TM1FORMAT_STRING)) {
                    formatString = this.mAccessor.getStringField(TM1CellsetFields.TM1FORMAT_STRING);
                } else if (this.mAccessor.containsField(TM1CellsetFields.FORMAT_STRING)) {
                    formatString = this.mAccessor.getStringField(TM1CellsetFields.FORMAT_STRING);
                }
                switch (this.mAccessor.getFieldType(TM1CellsetFields.VALUE)) {
                    case Boolean: {
                        value = ValueFactory.createBoolean((boolean)this.mAccessor.getBooleanField(TM1CellsetFields.VALUE));
                        break;
                    }
                    case Double: {
                        double dValue = this.mAccessor.getDoubleField(TM1CellsetFields.VALUE);
                        if (TM1Utils.isValidExcelDate(dValue)) {
                            Date dt = TM1Utils.convertExcelDate(dValue);
                            boolean hasDateFormat = TM1Utils.hasDateFormatting(formatString);
                            boolean hasTimeFormat = TM1Utils.hasTimeFormatting(formatString);
                            if (hasDateFormat) {
                                if (hasTimeFormat) {
                                    value = ValueFactory.createTimestamp((Date)dt, (TimeZone)queryCtx.getTimeZone());
                                    break;
                                }
                                value = ValueFactory.createDate((Date)dt, (TimeZone)queryCtx.getTimeZone());
                                break;
                            }
                            if (hasTimeFormat) {
                                value = ValueFactory.createTime((Date)dt, (TimeZone)queryCtx.getTimeZone());
                                break;
                            }
                        }
                        value = ValueFactory.createDouble((double)dValue);
                        break;
                    }
                    case Integer: {
                        value = ValueFactory.createLong((long)this.mAccessor.getIntegerField(TM1CellsetFields.VALUE));
                        break;
                    }
                    case String: {
                        String strValue = this.mAccessor.getStringField(TM1CellsetFields.VALUE);
                        if ("".equals(strValue) || "\u0011n".equals(strValue) || "\u0011r".equals(strValue)) {
                            isNull = true;
                            break;
                        }
                        if ("\u0011e".equals(strValue)) {
                            isError = true;
                            break;
                        }
                        if ("\u0011d".equals(strValue)) {
                            isDivByZero = true;
                            break;
                        }
                        if ("\u0011z".equals(strValue)) {
                            value = ValueFactory.createDouble((double)0.0);
                            break;
                        }
                        value = ValueFactory.createString((String)strValue);
                        break;
                    }
                    default: {
                        isError = true;
                    }
                }
                if (null != value) {
                    IValueFormat cachedFormat;
                    if (null == formatString) {
                        formatString = "";
                    }
                    if (null == (cachedFormat = this.mResultSet.getCachedFormat(formatString))) {
                        try {
                            cachedFormat = this.createValueFormat(formatString, value.getType());
                        }
                        catch (Exception ex) {
                            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::fetchNextCell()");
                        }
                    }
                    if (null != cachedFormat) {
                        ((ValueBase)value).setFormatter(cachedFormat);
                    }
                }
            } else {
                isError = true;
            }
            if (isNull) continue;
            if (isError) {
                value = ValueFactory.createString((int)1);
                value.setError();
            } else if (isDivByZero) {
                value = ValueFactory.createDouble((double)Double.NaN);
                value.setDivByZero();
            }
            this.mNextCell = new DataPoint();
            this.mNextCell.setOrdinal(this.mNextOrdinal);
            this.mNextCell.setValue((IValue)value);
            this.mHasNext = true;
            break;
        }
        return this.mHasNext;
    }

    private IValueFormat createValueFormat(String formatString, IDataType dataType) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Creating new IValueFormat [formatString='%s', dataType='%s', productLocale='%s']", formatString, dataType, this.mResultSet.getQueryContext().getProductLocale()), this.getClass().getName() + "::createValueFormat()");
        }
        IValueFormat format = QLSFormatService.getInstance().buildFormatInstance(formatString, dataType, this.mResultSet.getQueryContext().getContentLocale());
        this.mResultSet.putCachedFormat(format);
        return format;
    }

    public IDataPoint next() {
        this.assertNotClosed();
        if (this.mHasNext) {
            DataPoint cell = this.mNextCell;
            try {
                this.fetchNextCell();
            }
            catch (TM1Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::next()");
                throw TM1ProviderException.convert(ex);
            }
            return cell;
        }
        return null;
    }

    public boolean hasNext() {
        this.assertNotClosed();
        return this.mHasNext;
    }

    public void close() {
        this.mClosed = true;
    }

    void assertNotClosed() {
        if (this.mClosed) {
            throw new TM1ProviderException(CoreMessageKeys.GEN_FoundInternalErrorParam, "TM1CellIterator was closed");
        }
    }
}

