/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.format.IValueFormat;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.data.IDataPointIterator;
import com.ibm.cognos.aurora.api.query.provider.dim.IAxisIterator;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionRecord;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalDataProvider;
import com.ibm.cognos.aurora.api.query.provider.dim.IDimensionalResultSet;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.FieldIndex;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.MemberRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1DataProvider;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1AxisIterator;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data.TM1CellIterator;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MemberDepthHelper;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataLoader;
import com.ibm.cognos.tm1.Axis;
import com.ibm.cognos.tm1.Cellset;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.HashMap;
import java.util.Map;

public class TM1CubeResultSet
implements IDimensionalResultSet {
    private final TM1DataProvider mProvider;
    private final TM1Cube mCube;
    private final TM1Connection mConn;
    private final IQueryContext mQueryContext;
    private final Cellset mCellset;
    private final boolean mReturnConnectionOnClose;
    private final Axis[] mAxes;
    private int mNumAxes;
    private int mSlicerAxisOrdinal;
    private long[] mAxisCardinalities;
    private final Map<String, MemberRecord> mMemberCache = new HashMap<String, MemberRecord>();
    private final FieldIndex mSharedMemberFieldIndex = new FieldIndex();
    private final Map<String, IValueFormat> formatCache = new HashMap<String, IValueFormat>();
    private final MemberDepthHelper mDepthHelper;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");
    private volatile boolean mClosed = false;

    public TM1CubeResultSet(TM1DataProvider provider, TM1MetadataLoader metadataLoader, TM1Cube cube, TM1Connection conn, IQueryContext queryContext, int numExpectedAxes, Cellset cellset, boolean returnConnectionOnClose) {
        int i;
        this.mProvider = provider;
        this.mCube = cube;
        this.mQueryContext = queryContext;
        this.mConn = conn;
        this.mReturnConnectionOnClose = returnConnectionOnClose;
        this.mCellset = cellset;
        this.mAxes = cellset.getAxes();
        this.mNumAxes = this.mAxes.length;
        this.mSlicerAxisOrdinal = -1;
        this.mDepthHelper = new MemberDepthHelper(metadataLoader);
        int lastNonEmptyAxis = -1;
        for (i = this.mAxes.length - 1; i >= 0; --i) {
            if (this.mAxes[i].getDimensionNames().length > 0) {
                lastNonEmptyAxis = i;
                break;
            }
            --this.mNumAxes;
        }
        if (-1 != numExpectedAxes && this.mNumAxes > numExpectedAxes) {
            --this.mNumAxes;
            this.mSlicerAxisOrdinal = lastNonEmptyAxis;
        }
        this.mAxisCardinalities = new long[this.mNumAxes];
        for (i = 0; i < this.mAxisCardinalities.length; ++i) {
            this.mAxisCardinalities[i] = -1L;
        }
    }

    public IDimensionalDataProvider getProvider() {
        return this.mProvider;
    }

    public TM1Connection getConnection() {
        return this.mConn;
    }

    public TM1Cube getCube() {
        return this.mCube;
    }

    public String getCatalogName() {
        return "CATALOG";
    }

    public String getCubeName() {
        return this.mCube.getName();
    }

    public IQueryContext getQueryContext() {
        return this.mQueryContext;
    }

    public int getAxisCount() {
        return this.mNumAxes;
    }

    public IDimensionRecord[] getDimensions(int axisNumber) {
        this.assertNotClosed();
        String[] dimNames = this.mAxes[axisNumber].getDimensionNames();
        IDimensionRecord[] dims = new IDimensionRecord[dimNames.length];
        FieldIndex sharedFieldIndex = new FieldIndex();
        for (int i = 0; i < dimNames.length; ++i) {
            String dun = UniqueNameGenerator.createSingleNamePart((String)dimNames[i]);
            TM1Dimension dim = this.mCube.findDimension(dun);
            if (null == dim) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)dun);
            }
            dims[i] = MetadataRecordBuilder.buildDimension(dim, sharedFieldIndex);
        }
        return dims;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAxisCardinality(int axisNumber) {
        this.assertNotClosed();
        if (-1L == this.mAxisCardinalities[axisNumber]) {
            try {
                Rowset rs = this.mAxes[axisNumber].getTupleRowset();
                try {
                    this.mAxisCardinalities[axisNumber] = rs.getCount();
                }
                finally {
                    rs.dispose();
                }
            }
            catch (TM1Exception ex) {
                throw TM1ProviderException.convert(ex);
            }
        }
        return this.mAxisCardinalities[axisNumber];
    }

    public IAxisIterator getAxisIterator(int axisNumber) {
        this.assertNotClosed();
        try {
            return new TM1AxisIterator(this, this.mAxes[axisNumber]);
        }
        catch (TM1Exception ex) {
            throw TM1ProviderException.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMemberRecord[] getSlicer() {
        this.assertNotClosed();
        if (-1 == this.mSlicerAxisOrdinal) {
            return null;
        }
        IAxisIterator axisIter = this.getAxisIterator(this.mSlicerAxisOrdinal);
        try {
            IMemberRecord[] iMemberRecordArray = axisIter.next();
            return iMemberRecordArray;
        }
        finally {
            axisIter.close();
        }
    }

    public IDataPointIterator getCellIterator() {
        this.assertNotClosed();
        try {
            return new TM1CellIterator(this, this.mCellset);
        }
        catch (TM1Exception ex) {
            throw TM1ProviderException.convert(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.mClosed) {
            return;
        }
        try {
            for (Axis a : this.mAxes) {
                try {
                    a.dispose();
                }
                catch (Exception ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::close()", (Throwable)ex);
                }
            }
            try {
                this.mCellset.dispose();
            }
            catch (Exception ex) {
                logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::close()", (Throwable)ex);
            }
        }
        finally {
            this.mMemberCache.clear();
            this.formatCache.clear();
            this.mClosed = true;
            if (this.mReturnConnectionOnClose) {
                this.mConn.returnToPool();
            }
        }
    }

    FieldIndex getSharedMemberFieldIndex() {
        return this.mSharedMemberFieldIndex;
    }

    void putCachedMember(MemberRecord member) {
        this.mMemberCache.put(member.getUniqueName(), member);
    }

    MemberRecord getCachedMember(String mun) {
        return this.mMemberCache.get(mun);
    }

    IValueFormat getCachedFormat(String formatString) {
        return this.formatCache.get(formatString);
    }

    void putCachedFormat(IValueFormat format) {
        this.formatCache.put(format.getDsFormatString(), format);
    }

    Map<String, IValueFormat> getFormatCache() {
        return this.formatCache;
    }

    MemberDepthHelper getDepthHelper() {
        return this.mDepthHelper;
    }

    void assertNotClosed() {
        if (this.mClosed) {
            throw new TM1ProviderException(CoreMessageKeys.GEN_FoundInternalErrorParam, "TM1CubeResultSet was closed");
        }
    }
}

