/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.data;

import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1ProviderException;
import com.ibm.cognos.tm1.Blob;
import com.ibm.cognos.tm1.TM1Exception;

public class TM1ObjectAccessor {
    private final TM1Connection mConnection;

    public TM1ObjectAccessor(TM1Connection connection) {
        this.mConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBlob(String blobId) {
        byte[] bytes = null;
        try {
            Blob blob = this.mConnection.getServer().findBlob(blobId);
            if (blob == null) {
                throw new QLSRuntimeException(TM1MessageKeys.OAC_BlobNotFound, (Object)blobId);
            }
            try {
                blob.open();
                try {
                    bytes = blob.read(0L, blob.getSize());
                }
                finally {
                    blob.close();
                }
            }
            finally {
                blob.dispose();
            }
        }
        catch (TM1Exception e) {
            throw TM1ProviderException.convert(e);
        }
        return bytes;
    }
}

