/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1CubeTimestamps;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class TM1CubeCache {
    private static final long DEFAULT_STALE_CHECK_INTERVAL = 5000L;
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");
    private final TM1Connection mConnection;
    private final Map<String, TM1Cube> mCubesByName = new HashMap<String, TM1Cube>();
    private long mStaleCheckInterval = 5000L;
    private volatile long mLastStaleCheckTime = 0L;
    private final AtomicBoolean mRunningStaleCheck = new AtomicBoolean(false);

    public TM1CubeCache(TM1Connection connection) {
        this.mConnection = connection;
    }

    public long getStaleCheckInterval() {
        return this.mStaleCheckInterval;
    }

    public void setStaleCheckInterval(long staleCheckInterval) {
        this.mStaleCheckInterval = staleCheckInterval;
    }

    public long getLastStaleCheckTime() {
        return this.mLastStaleCheckTime;
    }

    public synchronized boolean containsCube(String cubeName) {
        return this.mCubesByName.containsKey(cubeName);
    }

    public synchronized TM1Cube getCube(String cubeName) {
        return this.mCubesByName.get(cubeName);
    }

    public synchronized void putCube(TM1Cube cube) {
        this.mCubesByName.put(cube.getName(), cube);
    }

    public synchronized void removeCube(String cubeName) {
        this.mCubesByName.remove(cubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkStaleCubes() {
        long currentTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
        if (currentTime - this.mLastStaleCheckTime >= this.mStaleCheckInterval && this.mRunningStaleCheck.compareAndSet(false, true)) {
            try {
                int connectionId = System.identityHashCode((Object)this.mConnection);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Running stale check on cube cache [CONNECTION_ID=%h]", connectionId), this.getClass().getName() + "::checkStaleCubes()");
                }
                TM1MetadataSession session = new TM1MetadataSession(this.mConnection);
                LinkedList<String> staleCubeNames = new LinkedList<String>();
                this.mLastStaleCheckTime = currentTime;
                Object object = this;
                synchronized (object) {
                    for (TM1Cube cachedCube : this.mCubesByName.values()) {
                        try {
                            TM1CubeTimestamps currentTimestamps = session.getCubeTimestamps(cachedCube.getName());
                            if (0 == currentTimestamps.compareLastSchemaUpdate(cachedCube.getTimestamps())) continue;
                            staleCubeNames.add(cachedCube.getName());
                        }
                        catch (Exception ex) {
                            staleCubeNames.add(cachedCube.getName());
                        }
                    }
                    for (String cubeName : staleCubeNames) {
                        if (logger.isInfoEnabled()) {
                            logger.info(String.format("Expunging stale metadata from cube cache [CONNECTION_ID=%h, CUBE=%s]", connectionId, cubeName), this.getClass().getName() + "::checkStaleCubes");
                        }
                        this.mCubesByName.remove(cubeName);
                    }
                }
                object = staleCubeNames;
                return object;
            }
            finally {
                this.mRunningStaleCheck.set(false);
            }
        }
        return Collections.emptyList();
    }
}

