/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Attribute;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Metadata;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataType;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1Field;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TraceObject;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class TM1Hierarchy
extends TM1Metadata {
    private String mAllMemberUN;
    private String mDefaultMemberUN;
    private int mStructure = 0;
    private boolean mRagged = false;
    private boolean mRaggedStateKnown = false;
    private boolean mBalanced = false;
    private boolean mBalancedStateKnown = false;
    private boolean mParentChild = false;
    private boolean mParentChildStateKnown = false;
    private long mCardinality;
    private final Map<String, TM1Level> mLevelsByLUN = new HashMap<String, TM1Level>();
    private final List<TM1Level> mLevelsByNumber = new ArrayList<TM1Level>();
    private List<TM1Member> mAccessibleRoots = Collections.emptyList();
    private final Map<String, TM1Attribute> mAttributesByName = new LinkedHashMap<String, TM1Attribute>();
    private String mCommonMUNPrefix;

    public TM1Hierarchy(TM1Dimension dimension) {
        super(dimension);
    }

    @Override
    public TM1MetadataType getType() {
        return TM1MetadataType.HIERARCHY;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = TM1Utils.joinUniqueNames(this.getDimension().getUniqueName(), this.getProviderUniqueName());
        }
        return this.mUniqueName;
    }

    public TM1Dimension getDimension() {
        return (TM1Dimension)this.getParent();
    }

    public String getAllMemberUN() {
        return this.mAllMemberUN;
    }

    public String getDefaultMemberUN() {
        return this.mDefaultMemberUN;
    }

    public int getStructure() {
        return this.mStructure;
    }

    public boolean isRagged() {
        if (!this.mRaggedStateKnown) {
            this.mRagged = false;
            for (TM1Member m : this.mAccessibleRoots) {
                if (m.getLevelNumber() == 0) continue;
                this.mRagged = true;
                break;
            }
            this.mRaggedStateKnown = true;
        }
        return this.mRagged;
    }

    public boolean isBalanced() {
        if (!this.mBalancedStateKnown) {
            this.mBalanced = true;
            Iterator<TM1Member> rootIter = this.mAccessibleRoots.iterator();
            if (rootIter.hasNext()) {
                int levelNumber = rootIter.next().getLevelNumber();
                while (rootIter.hasNext()) {
                    if (rootIter.next().getLevelNumber() == levelNumber) continue;
                    this.mBalanced = false;
                    break;
                }
            }
            this.mBalancedStateKnown = true;
        }
        return this.mBalanced;
    }

    public boolean isParentChild() {
        if (!this.mParentChildStateKnown) {
            this.mParentChild = true;
            for (TM1Level l : this.mLevelsByNumber) {
                String expectedLabel = String.format("level%03d", l.getLevelNumber());
                if (l.getProviderCaption().equals(expectedLabel)) continue;
                this.mParentChild = false;
                break;
            }
            this.mParentChildStateKnown = true;
        }
        return this.mParentChild;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public Collection<TM1Level> getLevels() {
        return Collections.unmodifiableCollection(this.mLevelsByNumber);
    }

    public TM1Level findLevel(String lun) {
        return this.mLevelsByLUN.get(lun);
    }

    public TM1Level findLevel(int levelNumber) {
        if (levelNumber >= 0 && levelNumber < this.mLevelsByNumber.size()) {
            return this.mLevelsByNumber.get(levelNumber);
        }
        return null;
    }

    public List<TM1Member> getAccessibleRoots() {
        return Collections.unmodifiableList(this.mAccessibleRoots);
    }

    public Collection<TM1Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.mAttributesByName.values());
    }

    public TM1Attribute findAttribute(String name) {
        return this.mAttributesByName.get(name);
    }

    public String getCommonMUNPrefix() {
        return this.mCommonMUNPrefix;
    }

    public void populate(ITM1RowsetView<TM1HierarchyFields> view) throws TM1Exception {
        this.mName = view.getStringField(TM1HierarchyFields.HIERARCHY_NAME);
        this.mProviderUniqueName = view.getStringField(TM1HierarchyFields.HIERARCHY_UNIQUE_NAME);
        this.mProviderCaption = view.getStringField(TM1HierarchyFields.HIERARCHY_CAPTION);
        this.mAllMemberUN = view.getStringField(TM1HierarchyFields.ALL_MEMBER);
        this.mDefaultMemberUN = view.getStringField(TM1HierarchyFields.DEFAULT_MEMBER);
        this.mCardinality = view.getIntegerField(TM1HierarchyFields.HIERARCHY_CARDINALITY);
        if (view.containsField(TM1HierarchyFields.STRUCTURE)) {
            this.mStructure = (int)view.getIntegerField(TM1HierarchyFields.STRUCTURE);
            this.mBalanced = 0 == this.mStructure || 1 == this.mStructure;
            this.mBalancedStateKnown = true;
        } else {
            this.mStructure = 0;
            this.mRaggedStateKnown = false;
            this.mBalancedStateKnown = false;
            this.mParentChildStateKnown = false;
        }
        this.mCommonMUNPrefix = TM1Utils.createCommonMUNPrefix(this.getProviderUniqueName(), this.getDimension().getProviderUniqueName());
    }

    @Override
    public TraceObject toTraceObject() {
        TraceObject trace = new TraceObject("TM1Hierarchy");
        trace.setAttribute("name", this.getName());
        trace.setAttribute("uniqueName", this.getUniqueName());
        trace.setAttribute("caption", this.getCaption());
        trace.setAttribute("structure", this.getStructure());
        trace.setAttribute("cardinality", this.getCardinality());
        trace.setAttribute("allMemberUN", this.getAllMemberUN());
        trace.setAttribute("defaultMemberUN", this.getDefaultMemberUN());
        for (TM1Attribute attribute : this.getAttributes()) {
            trace.addChild(attribute.toTraceObject());
        }
        for (TM1Level level : this.getLevels()) {
            trace.addChild(level.toTraceObject());
        }
        return trace;
    }

    void addLevel(TM1Level level) {
        this.mLevelsByLUN.put(level.getProviderUniqueName(), level);
        int levelsToAdd = level.getLevelNumber() - this.mLevelsByNumber.size() + 1;
        if (levelsToAdd > 0) {
            for (int i = 0; i < levelsToAdd; ++i) {
                this.mLevelsByNumber.add(null);
            }
        }
        this.mLevelsByNumber.set(level.getLevelNumber(), level);
    }

    void addAttribute(TM1Attribute attribute) {
        this.mAttributesByName.put(attribute.getName(), attribute);
    }

    void setAccessibleRoots(List<TM1Member> roots) {
        this.mAccessibleRoots = roots;
    }

    public static enum TM1HierarchyFields implements ITM1Field
    {
        CUBE_NAME,
        DIMENSION_UNIQUE_NAME,
        HIERARCHY_NAME,
        HIERARCHY_UNIQUE_NAME,
        HIERARCHY_CAPTION,
        DIMENSION_TYPE,
        HIERARCHY_CARDINALITY,
        DEFAULT_MEMBER,
        ALL_MEMBER,
        STRUCTURE;

        private final String mFieldName;

        private TM1HierarchyFields() {
            this.mFieldName = this.name();
        }

        private TM1HierarchyFields(String fieldName) {
            this.mFieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.mFieldName;
        }
    }
}

