/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata;

import com.ibm.cognos.aurora.api.query.provider.dim.EPropertyRole;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Attribute;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1CubeCache;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.ITM1RowsetView;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1RowsetAccessor;
import com.ibm.cognos.tm1.Cube;
import com.ibm.cognos.tm1.Rowset;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class TM1MetadataLoader {
    private static final String[] DEFAULT_MEMBER_FIELDS = new String[]{TM1Member.TM1MemberFields.PARENT_UNIQUE_NAME.getFieldName(), TM1Member.TM1MemberFields.PARENT_LEVEL.getFieldName(), TM1Member.TM1MemberFields.MEMBER_ORDINAL.getFieldName(), TM1Member.TM1MemberFields.MEMBER_NAME.getFieldName(), TM1Member.TM1MemberFields.MEMBER_UNIQUE_NAME.getFieldName(), TM1Member.TM1MemberFields.MEMBER_CAPTION.getFieldName(), TM1Member.TM1MemberFields.LEVEL_NUMBER.getFieldName(), TM1Member.TM1MemberFields.CHILDREN_CARDINALITY.getFieldName()};
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");
    private final TM1Connection mConnection;

    public TM1MetadataLoader(TM1Connection connection) {
        this.mConnection = connection;
    }

    public TM1Cube loadCube(String cubeName) throws TM1Exception {
        TM1CubeCache cubeCache = this.mConnection.getCubeCache();
        if (null != cubeCache) {
            cubeCache.checkStaleCubes();
            TM1Cube cube = cubeCache.getCube(cubeName);
            if (null == cube) {
                cube = this.bulkLoadCube(cubeName);
                if (null != cube) {
                    cubeCache.putCube(cube);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(String.format("Loading cube from cube cache [CONNECTION_ID=%h, CUBE=%s]", System.identityHashCode((Object)this.mConnection), cubeName), TM1MetadataLoader.class.getName() + "::loadCube()");
            }
            return cube;
        }
        return this.bulkLoadCube(cubeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TM1Cube shallowLoadCube(String cubeName) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Shallow-loading cube [CONNECTION_ID=%h, CUBE=%s]", System.identityHashCode((Object)this.mConnection), cubeName), TM1MetadataLoader.class.getName() + "::shallowLoadCube()");
        }
        Server serverAPI = this.mConnection.getServer();
        Cube cubeAPI = serverAPI.findCube(cubeName);
        TM1Cube cube = null;
        if (null != cubeAPI) {
            try {
                cube = new TM1Cube();
                cube.populate(cubeAPI);
            }
            finally {
                cubeAPI.dispose();
            }
        }
        return cube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TM1Cube> shallowLoadAllCubes() throws TM1Exception {
        Server serverAPI = this.mConnection.getServer();
        ArrayList<TM1Cube> allCubes = new ArrayList<TM1Cube>();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Shallow-loading all cubes [CONNECTION_ID=%h]", System.identityHashCode((Object)this.mConnection)), TM1MetadataLoader.class.getName() + "::shallowLoadAllCubes()");
        }
        Cube[] allCubeAPIs = serverAPI.listCubes();
        try {
            for (Cube cubeAPI : allCubeAPIs) {
                TM1Cube cube = new TM1Cube();
                cube.populate(cubeAPI);
                allCubes.add(cube);
            }
        }
        finally {
            for (Cube cubeAPI : allCubeAPIs) {
                cubeAPI.dispose();
            }
        }
        return allCubes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TM1Member> loadAccessibleRootMembers(TM1Hierarchy hierarchy) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading accessible root members [CONNECTION_ID=%h, CUBE=%s, HUN=%s]", System.identityHashCode((Object)this.mConnection), hierarchy.getDimension().getCube().getName(), hierarchy.getUniqueName()), TM1MetadataLoader.class.getName() + "::loadAccessibleRootMembers()");
        }
        Server serverAPI = this.mConnection.getServer();
        ArrayList<TM1Member> roots = new ArrayList<TM1Member>();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = dimension.getAliasNames();
        String[] fields = aliasNames.isEmpty() ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames);
        Rowset rs = serverAPI.getAccessibleRootsRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                roots.add(this.loadMemberFromRowset(hierarchy, rowsetAccessor));
            }
        }
        finally {
            rs.dispose();
        }
        return roots;
    }

    public TM1Member loadSingleMember(TM1Hierarchy hierarchy, String mun) throws TM1Exception {
        ArrayList<TM1Member> members = new ArrayList<TM1Member>(1);
        this.loadMembersTreeOp(hierarchy, mun, EnumSet.of(TreeOperator.Self), members);
        if (members.size() > 0) {
            return (TM1Member)members.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMembersTreeOp(TM1Hierarchy hierarchy, String mun, EnumSet<TreeOperator> treeOps, List<TM1Member> result) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading members with TREEOPS [CONNECTION_ID=%h, CUBE=%s, HUN=%s, MUN=%s, TREEOPS=%s]", System.identityHashCode((Object)this.mConnection), hierarchy.getDimension().getCube().getName(), hierarchy.getUniqueName(), mun, String.valueOf(treeOps)), TM1MetadataLoader.class.getName() + "::loadMembersTreeOp()");
        }
        Server serverAPI = this.mConnection.getServer();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = dimension.getAliasNames();
        String[] fields = aliasNames.isEmpty() ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames);
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), null, mun, treeOps, fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                result.add(this.loadMemberFromRowset(hierarchy, rowsetAccessor));
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadAncestorCount(TM1Hierarchy hierarchy, String mun) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading member ancestor count [CONNECTION_ID=%h, CUBE=%s, HUN=%s, MUN=%s]", System.identityHashCode((Object)this.mConnection), hierarchy.getDimension().getCube().getName(), hierarchy.getUniqueName(), mun), TM1MetadataLoader.class.getName() + "::loadAncestorCount()");
        }
        Server serverAPI = this.mConnection.getServer();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), null, mun, TreeOperator.Ancestors, new String[0]);
        try {
            int n = (int)rs.getCount();
            return n;
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHierarchyMembers(TM1Hierarchy hierarchy, List<TM1Member> result) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading hierarchy members [CONNECTION_ID=%h, CUBE=%s, HUN=%s]", System.identityHashCode((Object)this.mConnection), hierarchy.getDimension().getCube().getName(), hierarchy.getUniqueName()), TM1MetadataLoader.class.getName() + "::loadHierarchyMembers()");
        }
        Server serverAPI = this.mConnection.getServer();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = dimension.getAliasNames();
        String[] fields = aliasNames.isEmpty() ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames);
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), null, null, EnumSet.of(TreeOperator.Self), fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                result.add(this.loadMemberFromRowset(hierarchy, rowsetAccessor));
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLevelMembers(TM1Level level, List<TM1Member> result) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loading level members [CONNECTION_ID=%h, CUBE=%s, LUN=%s]", System.identityHashCode((Object)this.mConnection), level.getHierarchy().getDimension().getCube().getName(), level.getUniqueName()), TM1MetadataLoader.class.getName() + "::loadLevelMembers()");
        }
        Server serverAPI = this.mConnection.getServer();
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        List<String> aliasNames = dimension.getAliasNames();
        String[] fields = aliasNames.isEmpty() ? DEFAULT_MEMBER_FIELDS : this.buildMemberFields(aliasNames);
        Rowset rs = serverAPI.getMembersRowset(cube.getName(), dimension.getProviderUniqueName(), hierarchy.getProviderUniqueName(), level.getProviderUniqueName(), null, EnumSet.of(TreeOperator.Self), fields);
        try {
            TM1RowsetAccessor<TM1Member.TM1MemberFields> rowsetAccessor = TM1RowsetAccessor.create(rs, TM1Member.TM1MemberFields.class);
            while (rowsetAccessor.next()) {
                result.add(this.loadMemberFromRowset(level, rowsetAccessor));
            }
        }
        finally {
            rs.dispose();
        }
    }

    private TM1Member loadMemberFromRowset(TM1Hierarchy hierarchy, ITM1RowsetView<TM1Member.TM1MemberFields> rowsetAccessor) throws TM1Exception {
        int levelNum = (int)rowsetAccessor.getIntegerField(TM1Member.TM1MemberFields.LEVEL_NUMBER);
        TM1Level level = hierarchy.findLevel(levelNum);
        if (null == level) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_LevelNumberNotFound, (Object)levelNum, (Object)hierarchy.getUniqueName());
        }
        TM1Member member = new TM1Member(level);
        member.populate(rowsetAccessor);
        return member;
    }

    private TM1Member loadMemberFromRowset(TM1Level level, ITM1RowsetView<TM1Member.TM1MemberFields> rowsetAccessor) throws TM1Exception {
        TM1Member member = new TM1Member(level);
        member.populate(rowsetAccessor);
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TM1Cube bulkLoadCube(String cubeName) throws TM1Exception {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Bulk-loading cube metadata [CONNECTION_ID=%h, CUBE=%s]", System.identityHashCode((Object)this.mConnection), cubeName), TM1MetadataLoader.class.getName() + "::bulkLoadCube()");
        }
        Server serverAPI = this.mConnection.getServer();
        Cube cubeAPI = serverAPI.findCube(cubeName);
        TM1Cube cube = null;
        if (null != cubeAPI) {
            try {
                cube = new TM1Cube();
                cube.populate(cubeAPI);
                this.bulkLoadDimensions(cube);
                this.bulkLoadHierarchies(cube);
                this.bulkLoadLevels(cube);
                this.bulkLoadAccessibleRootMembers(cube);
                this.bulkLoadAttributes(cube);
            }
            finally {
                cubeAPI.dispose();
            }
        }
        return cube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadDimensions(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.mConnection.getServer();
        Rowset rs = serverAPI.getDimensionsRowset(cube.getName(), null, cube.isControlObject());
        try {
            TM1RowsetAccessor<TM1Dimension.TM1DimensionFields> rsa = TM1RowsetAccessor.create(rs, TM1Dimension.TM1DimensionFields.class);
            while (rsa.next()) {
                TM1Dimension dimension = new TM1Dimension(cube);
                dimension.populate(rsa);
                cube.addDimension(dimension);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Bulk-loaded dimension [CONNECTION_ID=%h, CUBE=%s, DUN=%s]", System.identityHashCode((Object)this.mConnection), cube.getName(), dimension.getUniqueName()), TM1MetadataLoader.class.getName() + "::bulkLoadDimensions()");
                }
                if (!dimension.isControlObject()) continue;
                this.loadDefaultHierarchy(dimension);
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadHierarchies(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.mConnection.getServer();
        Rowset rs = serverAPI.getHierarchiesRowset(cube.getName(), null, null);
        try {
            TM1RowsetAccessor<TM1Hierarchy.TM1HierarchyFields> rsa = TM1RowsetAccessor.create(rs, TM1Hierarchy.TM1HierarchyFields.class);
            while (rsa.next()) {
                String dun = rsa.getStringField(TM1Hierarchy.TM1HierarchyFields.DIMENSION_UNIQUE_NAME);
                TM1Dimension dimension = cube.findDimension(dun);
                if (null == dimension) {
                    throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)dun);
                }
                TM1Hierarchy hierarchy = new TM1Hierarchy(dimension);
                hierarchy.populate(rsa);
                dimension.addHierarchy(hierarchy);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Bulk-loaded hierarchy [CONNECTION_ID=%h, CUBE=%s, HUN=%s]", System.identityHashCode((Object)this.mConnection), cube.getName(), hierarchy.getUniqueName()), TM1MetadataLoader.class.getName() + "::bulkLoadHierarchies()");
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultHierarchy(TM1Dimension dimension) throws TM1Exception {
        TM1Cube cube = dimension.getCube();
        Server serverAPI = this.mConnection.getServer();
        Rowset rs = serverAPI.getHierarchiesRowset(cube.getName(), dimension.getProviderUniqueName(), UniqueNameGenerator.createSingleNamePart((String)dimension.getDefaultHierarchyName()));
        try {
            TM1RowsetAccessor<TM1Hierarchy.TM1HierarchyFields> rsa = TM1RowsetAccessor.create(rs, TM1Hierarchy.TM1HierarchyFields.class);
            if (rsa.next()) {
                TM1Hierarchy hierarchy = new TM1Hierarchy(dimension);
                hierarchy.populate(rsa);
                dimension.addHierarchy(hierarchy);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Loaded default hierarchy of dimension [CONNECTION_ID=%h, CUBE=%s, DUN=%s, HUN=%s]", System.identityHashCode((Object)this.mConnection), cube.getName(), dimension.getUniqueName(), hierarchy.getUniqueName()), TM1MetadataLoader.class.getName() + "::loadDefaultHierarchy()");
                }
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadLevels(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.mConnection.getServer();
        Rowset rs = serverAPI.getLevelsRowset(cube.getName(), null, null, null);
        try {
            TM1RowsetAccessor<TM1Level.TM1LevelFields> rsa = TM1RowsetAccessor.create(rs, TM1Level.TM1LevelFields.class);
            while (rsa.next()) {
                String dun = rsa.getStringField(TM1Level.TM1LevelFields.DIMENSION_UNIQUE_NAME);
                TM1Dimension dimension = cube.findDimension(dun);
                if (null == dimension) {
                    throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)dun);
                }
                String hun = rsa.getStringField(TM1Level.TM1LevelFields.HIERARCHY_UNIQUE_NAME);
                TM1Hierarchy hierarchy = dimension.findHierarchy(hun);
                if (null == hierarchy) {
                    throw new QLSRuntimeException(TM1MessageKeys.MET_HierarchyNotFound, (Object)hun);
                }
                TM1Level level = new TM1Level(hierarchy);
                level.populate(rsa);
                hierarchy.addLevel(level);
                if (!logger.isDebugEnabled()) continue;
                logger.debug(String.format("Bulk-loaded level [CONNECTION_ID=%h, CUBE=%s, LUN=%s]", System.identityHashCode((Object)this.mConnection), cube.getName(), level.getUniqueName()), TM1MetadataLoader.class.getName() + "::bulkLoadLevels()");
            }
        }
        finally {
            rs.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkLoadAttributes(TM1Cube cube) throws TM1Exception {
        Server serverAPI = this.mConnection.getServer();
        Rowset rs = serverAPI.getAttributesRowset(cube.getName(), null, null, null, null);
        try {
            TM1RowsetAccessor<TM1Attribute.TM1AttributeFields> rsa = TM1RowsetAccessor.create(rs, TM1Attribute.TM1AttributeFields.class);
            while (rsa.next()) {
                String dun = rsa.getStringField(TM1Attribute.TM1AttributeFields.DIMENSION_UNIQUE_NAME);
                TM1Dimension dimension = cube.findDimension(dun);
                if (null == dimension) {
                    throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)dun);
                }
                TM1Attribute attribute = new TM1Attribute(dimension, EPropertyRole.CUSTOM_PROPERTY);
                attribute.populate(rsa);
                if (TM1MetadataLoader.canSkipAttribute(attribute)) continue;
                dimension.addAttribute(attribute);
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Bulk-loaded attribute [CONNECTION_ID=%h, CUBE=%s, DUN=%s, PUN=%s]", System.identityHashCode((Object)this.mConnection), cube.getName(), dimension.getUniqueName(), attribute.getUniqueName()), TM1MetadataLoader.class.getName() + "::bulkLoadAttributes()");
                }
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    attribute = new TM1Attribute(hierarchy, EPropertyRole.CUSTOM_PROPERTY);
                    attribute.populate(rsa);
                    hierarchy.addAttribute(attribute);
                    if (hierarchy.isParentChild()) continue;
                    for (TM1Level level : hierarchy.getLevels()) {
                        attribute = new TM1Attribute(level, EPropertyRole.CUSTOM_PROPERTY);
                        attribute.populate(rsa);
                        level.addAttribute(attribute);
                    }
                }
            }
        }
        finally {
            rs.dispose();
        }
    }

    private static boolean canSkipAttribute(TM1Attribute attribute) throws TM1Exception {
        if ((null == attribute.getDescription() || 0 == attribute.getDescription().length()) && "Format".equals(attribute.getName())) {
            return true;
        }
        return "DESCRIPTION".equals(attribute.getName());
    }

    private void bulkLoadAccessibleRootMembers(TM1Cube cube) throws TM1Exception {
        for (TM1Dimension dimension : cube.getDimensions()) {
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                List<TM1Member> roots = this.loadAccessibleRootMembers(hierarchy);
                hierarchy.setAccessibleRoots(roots);
            }
        }
    }

    private String[] buildMemberFields(List<String> customFields) {
        String[] result = new String[DEFAULT_MEMBER_FIELDS.length + customFields.size()];
        System.arraycopy(DEFAULT_MEMBER_FIELDS, 0, result, 0, DEFAULT_MEMBER_FIELDS.length);
        int i = DEFAULT_MEMBER_FIELDS.length;
        for (String fieldName : customFields) {
            result[i++] = fieldName;
        }
        return result;
    }
}

