/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.ICubeRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CubeRecordQuery
extends MetadataQuery<ICubeRecord> {
    private String mCubeName = null;

    public CubeRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    @Override
    public List<ICubeRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        if (null != this.mCubeName) {
            TM1Cube cube = this.getLoader().shallowLoadCube(this.mCubeName);
            if (null == cube) {
                return Collections.emptyList();
            }
            if (this.isInRange(0)) {
                return Collections.singletonList(MetadataRecordBuilder.buildCube(cube, this.mSharedFieldIndex));
            }
            return Collections.emptyList();
        }
        List<TM1Cube> allCubes = this.getLoader().shallowLoadAllCubes();
        int effectiveSize = Math.min(this.mRangeSize, allCubes.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ICubeRecord> records = new ArrayList<ICubeRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add((ICubeRecord)MetadataRecordBuilder.buildCube(allCubes.get(i), this.mSharedFieldIndex));
        }
        return records;
    }

    @Override
    public void release() {
        super.release();
    }
}

