/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.ILevelRecord;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LevelRecordQuery
extends MetadataQuery<ILevelRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private Integer mLevelNumber = null;

    public LevelRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setLevelNumber(Integer levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    @Override
    public List<ILevelRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new IllegalArgumentException("A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        ArrayList<TM1Level> levelsFound = new ArrayList<TM1Level>();
        if (null != this.mLUN) {
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, false);
            if (null != level) {
                levelsFound.add(level);
            }
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy) {
                this.addLevelsFromHierarchy(hierarchy, levelsFound);
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    this.addLevelsFromHierarchy(hierarchy, levelsFound);
                }
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    this.addLevelsFromHierarchy(hierarchy, levelsFound);
                }
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, levelsFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<ILevelRecord> records = new ArrayList<ILevelRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add((ILevelRecord)MetadataRecordBuilder.buildLevel((TM1Level)levelsFound.get(i), this.mSharedFieldIndex));
        }
        return records;
    }

    private void addLevelsFromHierarchy(TM1Hierarchy hierarchy, List<TM1Level> result) {
        if (null != this.mLevelNumber) {
            TM1Level level = hierarchy.findLevel(this.mLevelNumber);
            if (null != level) {
                result.add(level);
            }
        } else {
            result.addAll(hierarchy.getLevels());
        }
    }

    @Override
    public void release() {
    }
}

