/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.ETreeOp;
import com.ibm.cognos.aurora.api.query.provider.dim.IMemberRecord;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.metadata.MemberRecord;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MemberDepthHelper;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import com.ibm.cognos.tm1.TreeOperator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class MemberRecordQuery
extends MetadataQuery<IMemberRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private Integer mLevelNumber = null;
    private String mMUN = null;
    private EnumSet<ETreeOp> mTreeOps = null;
    private final MemberDepthHelper mDepthHelper = new MemberDepthHelper(this.getLoader());

    public MemberRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setLevelNumber(Integer levelNumber) {
        this.mLevelNumber = levelNumber;
    }

    public void setMUN(String mun) {
        this.mMUN = mun;
    }

    public void setTreeOps(EnumSet<ETreeOp> treeOps) {
        this.mTreeOps = treeOps;
    }

    @Override
    public List<IMemberRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new IllegalArgumentException("A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        EnumSet<TreeOperator> tm1TreeOps = null != this.mTreeOps ? MemberRecordQuery.convertTreeOps(this.mTreeOps) : EnumSet.noneOf(TreeOperator.class);
        ArrayList<TM1Member> membersFound = new ArrayList<TM1Member>();
        if (null != this.mMUN) {
            this.findMembersWithTreeOps(cube, tm1TreeOps, membersFound);
        } else {
            this.findMembers(cube, membersFound);
        }
        int effectiveSize = Math.min(this.mRangeSize, membersFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<IMemberRecord> records = new ArrayList<IMemberRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            TM1Member mem = (TM1Member)membersFound.get(i);
            TM1Hierarchy hierarchy = mem.getLevel().getHierarchy();
            MemberRecord rec = MetadataRecordBuilder.buildMember(mem, this.mSharedFieldIndex);
            if (hierarchy.isRagged()) {
                rec.setDepth(this.mDepthHelper.getMemberDepth(hierarchy, mem.getProviderUniqueName()));
            } else {
                rec.setDepth(mem.getLevelNumber());
            }
            records.add((IMemberRecord)rec);
        }
        return records;
    }

    private void findMembersWithTreeOps(TM1Cube cube, EnumSet<TreeOperator> treeOps, List<TM1Member> result) throws TM1Exception {
        if (null == treeOps) {
            throw new IllegalArgumentException("treeOps missing");
        }
        String providerMUN = TM1Utils.convertMDDSMUNToProviderMUN(this.mMUN);
        String providerDUN = TM1Utils.extractProviderDUNFromMDDSMUN(this.mMUN);
        String providerHUN = TM1Utils.extractProviderHUNFromMDDSMUN(this.mMUN);
        TM1Dimension dimension = cube.findDimension(providerDUN);
        if (null == dimension) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)providerDUN);
        }
        TM1Hierarchy hierarchy = dimension.findHierarchy(providerHUN);
        if (null == hierarchy) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_HierarchyNotFound, (Object)providerHUN);
        }
        this.getLoader().loadMembersTreeOp(hierarchy, providerMUN, treeOps, result);
    }

    private void findMembers(TM1Cube cube, List<TM1Member> result) throws TM1Exception {
        if (null != this.mLUN) {
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, true);
            this.getLoader().loadLevelMembers(level, result);
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, true);
            this.findMembers(hierarchy, result);
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, true);
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                this.findMembers(hierarchy, result);
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    this.findMembers(hierarchy, result);
                }
            }
        }
    }

    private void findMembers(TM1Hierarchy hierarchy, List<TM1Member> result) throws TM1Exception {
        if (null != this.mLevelNumber) {
            TM1Level level = hierarchy.findLevel(this.mLevelNumber);
            if (null != level) {
                this.getLoader().loadLevelMembers(level, result);
            }
        } else {
            this.getLoader().loadHierarchyMembers(hierarchy, result);
        }
    }

    private static EnumSet<TreeOperator> convertTreeOps(EnumSet<ETreeOp> xqeTreeOps) {
        EnumSet<TreeOperator> result = EnumSet.noneOf(TreeOperator.class);
        block8: for (ETreeOp op : xqeTreeOps) {
            switch (op) {
                case ANCESTORS: {
                    result.add(TreeOperator.Ancestors);
                    continue block8;
                }
                case CHILDREN: {
                    result.add(TreeOperator.Children);
                    continue block8;
                }
                case DESCENDANTS: {
                    result.add(TreeOperator.Descendants);
                    continue block8;
                }
                case PARENT: {
                    result.add(TreeOperator.Parent);
                    continue block8;
                }
                case SELF: {
                    result.add(TreeOperator.Self);
                    continue block8;
                }
                case SIBLINGS: {
                    result.add(TreeOperator.Siblings);
                    continue block8;
                }
            }
            throw new RuntimeException("Unsupported ETreeOp value: " + op.toString());
        }
        return result;
    }

    @Override
    public void release() {
    }
}

