/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.core.util.LocaleUtil;
import com.ibm.cognos.aurora.qls.query.provider.FieldIndex;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.TM1Connection;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataLoader;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.tm1.Server;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.List;
import java.util.Locale;

public abstract class MetadataQuery<RESULT_TYPE> {
    protected static final Locale DEFAULT_LOCALE = LocaleUtil.localeFromString((String)"en-us");
    private final TM1MetadataSession mSession;
    protected final FieldIndex mSharedFieldIndex = new FieldIndex();
    protected int mRangeFrom = 0;
    protected int mRangeSize = Integer.MAX_VALUE;

    protected MetadataQuery(TM1MetadataSession session) {
        this.mSession = session;
    }

    public final void setRangeFrom(int from) {
        this.mRangeFrom = from;
    }

    public final void setRangeSize(int size) {
        this.mRangeSize = size;
    }

    protected final boolean isInRange(int index) {
        return index >= this.mRangeFrom && index < this.mRangeFrom + this.mRangeSize;
    }

    protected final TM1MetadataSession getSession() {
        return this.mSession;
    }

    protected final TM1Connection getConnection() {
        return this.mSession.getConnection();
    }

    protected final Server getServer() {
        return this.mSession.getServer();
    }

    protected final TM1MetadataLoader getLoader() {
        return this.mSession.getLoader();
    }

    protected void checkRangeRestrictions() {
        if (this.mRangeFrom < 0 || this.mRangeSize < 0) {
            throw new IllegalArgumentException("Illegal from/size restriction range.");
        }
    }

    public abstract List<RESULT_TYPE> execute() throws TM1Exception;

    public void release() {
    }
}

