/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query;

import com.ibm.cognos.aurora.api.query.provider.dim.IPropertyRecord;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.MetadataRecordBuilder;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Attribute;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.query.MetadataQuery;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Utils;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PropertyRecordQuery
extends MetadataQuery<IPropertyRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mLUN = null;
    private String mPUN = null;

    public PropertyRecordQuery(TM1MetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setLUN(String lun) {
        this.mLUN = lun;
    }

    public void setPUN(String pun) {
        this.mPUN = pun;
    }

    @Override
    public List<IPropertyRecord> execute() throws TM1Exception {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new IllegalArgumentException("A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader().loadCube(this.mCubeName);
        if (null == cube) {
            throw new QLSRuntimeException(TM1MessageKeys.MET_CubeNotFound, (Object)this.mCubeName);
        }
        ArrayList<TM1Attribute> attributesFound = new ArrayList<TM1Attribute>();
        if (null != this.mPUN) {
            TM1Attribute attribute = TM1Utils.findAttribute(cube, this.mPUN);
            if (null != attribute) {
                attributesFound.add(attribute);
            }
        } else if (null != this.mLUN) {
            TM1Hierarchy hierarchy;
            TM1Level level = TM1Utils.findLevel(cube, this.mLUN, false);
            if (null != level && !(hierarchy = level.getHierarchy()).getDimension().isMeasureDimension() && !hierarchy.isParentChild()) {
                attributesFound.addAll(level.getAttributes());
            }
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy && !hierarchy.getDimension().isMeasureDimension()) {
                attributesFound.addAll(hierarchy.getAttributes());
                if (!hierarchy.isParentChild()) {
                    for (TM1Level level : hierarchy.getLevels()) {
                        attributesFound.addAll(level.getAttributes());
                    }
                }
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension && !dimension.isMeasureDimension()) {
                attributesFound.addAll(dimension.getAttributes());
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    attributesFound.addAll(hierarchy.getAttributes());
                    if (hierarchy.isParentChild()) continue;
                    for (TM1Level level : hierarchy.getLevels()) {
                        attributesFound.addAll(level.getAttributes());
                    }
                }
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                if (dimension.isMeasureDimension()) continue;
                attributesFound.addAll(dimension.getAttributes());
                for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                    attributesFound.addAll(hierarchy.getAttributes());
                    if (hierarchy.isParentChild()) continue;
                    for (TM1Level level : hierarchy.getLevels()) {
                        attributesFound.addAll(level.getAttributes());
                    }
                }
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, attributesFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<IPropertyRecord> records = new ArrayList<IPropertyRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add((IPropertyRecord)MetadataRecordBuilder.buildProperty((TM1Attribute)attributesFound.get(i), this.mSharedFieldIndex));
        }
        return records;
    }
}

