/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util;

import com.ibm.cognos.aurora.core.xml.DOM4JUtil;
import com.ibm.cognos.tm1.SSLConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class TM1SSLConfigs {
    public static final String DEFAULT_CONFIG_PATH = "../configuration/tm1.sslconfigs.xml";
    private final Map<String, SSLConfig> mAdminHost2Config = new HashMap<String, SSLConfig>();

    public void loadFile(File sslConfigsFile) throws IOException, DocumentException {
        Document doc = DOM4JUtil.parseDocument((File)sslConfigsFile);
        Element sslConfigsElem = doc.getRootElement();
        TM1SSLConfigs.assertElementName(sslConfigsElem, "sslconfigs");
        for (Element sslConfigElem : DOM4JUtil.elementsOf((Element)sslConfigsElem, (String)"sslconfig")) {
            String adminHost = TM1SSLConfigs.elementAttributeValue(sslConfigElem, "adminhost", "value");
            String certificateAuthority = TM1SSLConfigs.elementAttributeValue(sslConfigElem, "certificateAuthority", "file");
            String certificateId = TM1SSLConfigs.elementAttributeValue(sslConfigElem, "certificateId", "value");
            String certificateRevocationList = TM1SSLConfigs.elementAttributeValue(sslConfigElem, "certificateRevocationList", "file");
            if (null == adminHost || adminHost.length() == 0) {
                throw new DocumentException("adminhost was not specified in sslconfig");
            }
            if (null == certificateAuthority || certificateAuthority.length() == 0) {
                throw new DocumentException("certificateAuthority was not specified in sslconfig");
            }
            if (null == certificateId || certificateId.length() == 0) {
                throw new DocumentException("certificateId was not specified in sslconfig");
            }
            this.mAdminHost2Config.put(adminHost, SSLConfig.createSSLConfig((String)certificateAuthority, (String)certificateId, (String)certificateRevocationList));
        }
    }

    public String[] getAdminHosts() {
        return this.mAdminHost2Config.keySet().toArray(new String[0]);
    }

    public SSLConfig getSSLConfig(String adminHost) {
        return this.mAdminHost2Config.get(adminHost);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean separate = false;
        sb.append('{');
        for (Map.Entry<String, SSLConfig> e : this.mAdminHost2Config.entrySet()) {
            if (separate) {
                sb.append(", ");
            } else {
                separate = true;
            }
            sb.append(e.getKey()).append('=');
            sb.append("SSLConfig[certAuth=").append(e.getValue().getCertificateAuthority()).append(", certId=").append(e.getValue().getCertificateID()).append(", certRevocList=").append(e.getValue().getCertificateRevocationList()).append(']');
        }
        sb.append('}');
        return sb.toString();
    }

    private static String elementAttributeValue(Element elem, String childName, String attributeName) {
        Element childElem = elem.element(childName);
        if (null == childElem) {
            return null;
        }
        return childElem.attributeValue(attributeName);
    }

    private static void assertElementName(Element elem, String expectedName) throws DocumentException {
        if (!elem.getName().equals(expectedName)) {
            throw new DocumentException(String.format("Expected element '%s', but found '%s'.", expectedName, elem.getName()));
        }
    }
}

