/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util;

import com.ibm.cognos.aurora.api.exception.CoreMessageKeys;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.ISession;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.core.util.UniqueNameGenerator;
import com.ibm.cognos.aurora.core.util.UniqueNameParser;
import com.ibm.cognos.aurora.core.util.UniqueNameParserException;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.exception.TM1MessageKeys;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Attribute;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Cube;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Dimension;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Hierarchy;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Level;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Member;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1Metadata;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataSession;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.metadata.TM1MetadataType;
import com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util.TM1Constants;
import com.ibm.cognos.tm1.FieldType;
import com.ibm.cognos.tm1.TM1Exception;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.regex.Matcher;

public class TM1Utils {
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private static final String MEMBER_TAG = ".[@MEMBER].[";
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int MINUTES_PER_HOUR = 60;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;
    private static final long DAY_MILLISECONDS = 86400000L;
    private static final int EXCEL_START_YEAR = 1900;
    private static final ThreadLocal<Calendar> GREGORIAN_CALENDAR = new ThreadLocal();

    public static String joinUniqueNames(String uname1, String uname2) {
        StringBuilder buf = new StringBuilder(uname1.length() + uname2.length() + 1);
        buf.append(uname1).append('.').append(uname2);
        return buf.toString();
    }

    public static String convertMDDSHUNToProviderHUN(String mddsHUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsHUN);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)mddsHUN);
        }
        if (parts.length != 2) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS HUN (parts.length != 2): " + mddsHUN));
        }
        return UniqueNameGenerator.createUniqueName((String[])new String[]{parts[1]});
    }

    public static String convertMDDSLUNToProviderLUN(String mddsLUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsLUN);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)mddsLUN);
        }
        if (parts.length != 3) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS LUN (parts.length != 3): " + mddsLUN));
        }
        return UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[2]);
    }

    public static String convertProviderLUNToMDDSLUN(String providerLUN, String mddsHUN) {
        String[] lunParts;
        try {
            lunParts = UniqueNameParser.parse((String)providerLUN);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)providerLUN);
        }
        if (lunParts.length != 2) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid provider LUN (parts.length != 2): " + providerLUN));
        }
        return TM1Utils.joinUniqueNames(mddsHUN, UniqueNameGenerator.createSingleNamePart((String)lunParts[1]));
    }

    public static String createCommonMUNPrefix(String providerDUN, String providerHUN) {
        StringBuilder buf = new StringBuilder(providerDUN.length() + providerHUN.length() + MEMBER_TAG.length());
        buf.append(providerDUN).append('.').append(providerHUN).append(MEMBER_TAG);
        return buf.toString();
    }

    public static String createCommonMUNPrefix(TM1Dimension dim) {
        TM1Hierarchy hier = dim.getDefaultHierarchy();
        StringBuilder buf = new StringBuilder(hier.getUniqueName().length() + MEMBER_TAG.length());
        buf.append(hier.getUniqueName()).append(MEMBER_TAG);
        return buf.toString();
    }

    public static String ceateProviderMUN(String providerHUN, String uniqueNameComponent) {
        StringBuilder buf = new StringBuilder(providerHUN.length() + uniqueNameComponent.length() + 3);
        buf.append(providerHUN).append(".[").append(uniqueNameComponent).append(']');
        return buf.toString();
    }

    public static String createMDDSMUN(String munPrefix, String uniqueNameComponent) {
        StringBuilder buf = new StringBuilder(munPrefix.length() + uniqueNameComponent.length() + 1);
        buf.append(munPrefix).append(uniqueNameComponent).append(']');
        return buf.toString();
    }

    public static String convertProviderMUNToMDDSMUN(String munPrefix, String providerMUN) {
        String component = TM1Utils.extractLastUniqueNamePart(providerMUN);
        StringBuilder buf = new StringBuilder(munPrefix.length() + component.length() + 1);
        buf.append(munPrefix).append(component).append(']');
        return buf.toString();
    }

    public static String convertMDDSMUNToProviderMUN(String mddsMUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsMUN);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)mddsMUN);
        }
        if (parts.length != 4) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS MUN (parts.length != 4): " + mddsMUN));
        }
        return TM1Utils.ceateProviderMUN(UniqueNameGenerator.createSingleNamePart((String)parts[1]), parts[3]);
    }

    public static String extractProviderDUNFromMDDSMUN(String mddsMUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsMUN);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)mddsMUN);
        }
        return UniqueNameGenerator.createSingleNamePart((String)parts[0]);
    }

    public static String extractProviderHUNFromMDDSMUN(String mddsMUN) {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsMUN);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)mddsMUN);
        }
        return UniqueNameGenerator.createSingleNamePart((String)parts[1]);
    }

    private static String extractLastUniqueNamePart(String uniqueName) {
        try {
            return UniqueNameParser.parseLastIdentifier((String)uniqueName);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)uniqueName);
        }
    }

    public static String createMDDSPUN(TM1Dimension dimension, String property) {
        return TM1Utils.joinUniqueNames(dimension.getUniqueName(), UniqueNameGenerator.createSingleNamePart((String)property));
    }

    public static String createMDDSPUN(TM1Hierarchy hierarchy, String property) {
        return TM1Utils.joinUniqueNames(hierarchy.getUniqueName(), UniqueNameGenerator.createSingleNamePart((String)property));
    }

    public static String createMDDSPUN(TM1Level level, String property) {
        return TM1Utils.joinUniqueNames(level.getUniqueName(), UniqueNameGenerator.createSingleNamePart((String)property));
    }

    public static TM1Attribute findAttribute(TM1Cube cube, String pun) {
        TM1Level level;
        TM1Hierarchy hierarchy;
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)pun);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)pun);
        }
        if (parts.length < 2) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS PUN (parts.length < 2): " + pun));
        }
        if (parts.length > 4) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS PUN (parts.length > 4): " + pun));
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension || dimension.isMeasureDimension()) {
            return null;
        }
        if (parts.length > 2) {
            String providerHUN = UniqueNameGenerator.createSingleNamePart((String)parts[1]);
            hierarchy = dimension.findHierarchy(providerHUN);
            if (null == hierarchy) {
                return null;
            }
        } else {
            return dimension.findAttribute(parts[1]);
        }
        if (parts.length > 3) {
            if (hierarchy.isParentChild()) {
                level = null;
            } else {
                String providerLUN = UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[2]);
                level = hierarchy.findLevel(providerLUN);
            }
            if (null == level) {
                return null;
            }
        } else {
            return hierarchy.findAttribute(parts[2]);
        }
        return level.findAttribute(parts[3]);
    }

    public static TM1Metadata findMetadata(TM1MetadataSession metadataSession, TM1Cube cube, String mddsUniqueName) throws TM1Exception {
        String[] parts;
        try {
            parts = UniqueNameParser.parse((String)mddsUniqueName);
        }
        catch (UniqueNameParserException ex) {
            throw new QLSRuntimeException(QLSMessageKeys.PRV_UniqueNameParseError, (Object)mddsUniqueName);
        }
        if (0 == parts.length) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS unique name (parts.length == 0): " + mddsUniqueName));
        }
        if (parts.length > 4) {
            throw new QLSRuntimeException(CoreMessageKeys.GEN_FoundInternalErrorParam, (Object)("Invalid MDDS unique name (parts.length > 4): " + mddsUniqueName));
        }
        String dun = UniqueNameGenerator.createSingleNamePart((String)parts[0]);
        TM1Dimension dimension = cube.findDimension(dun);
        if (null == dimension) {
            return null;
        }
        if (1 == parts.length) {
            return dimension;
        }
        String providerHUN = UniqueNameGenerator.createSingleNamePart((String)parts[1]);
        TM1Hierarchy hierarchy = dimension.findHierarchy(providerHUN);
        if (null == hierarchy) {
            return null;
        }
        if (2 == parts.length) {
            return hierarchy;
        }
        if (3 == parts.length) {
            Matcher pcLevelNameMatcher = TM1Constants.PC_LEVEL_NAME_PATTERN.matcher(mddsUniqueName);
            if (pcLevelNameMatcher.find()) {
                int levelNumber = Integer.parseInt(pcLevelNameMatcher.group(1));
                return hierarchy.findLevel(levelNumber);
            }
            String providerLUN = UniqueNameGenerator.createUniqueName((String)parts[0], (String)parts[2]);
            return hierarchy.findLevel(providerLUN);
        }
        String providerMUN = TM1Utils.ceateProviderMUN(providerHUN, parts[3]);
        return metadataSession.getLoader().loadSingleMember(hierarchy, providerMUN);
    }

    public static TM1Dimension findDimension(TM1Cube cube, String mddsDUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(null, cube, mddsDUN);
        if (null == metadata || TM1MetadataType.DIMENSION != metadata.getType()) {
            if (mustResolve) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_DimensionNotFound, (Object)mddsDUN);
            }
            return null;
        }
        return (TM1Dimension)metadata;
    }

    public static TM1Hierarchy findHierarchy(TM1Cube cube, String mddsHUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(null, cube, mddsHUN);
        if (null == metadata || TM1MetadataType.HIERARCHY != metadata.getType()) {
            if (mustResolve) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_HierarchyNotFound, (Object)mddsHUN);
            }
            return null;
        }
        return (TM1Hierarchy)metadata;
    }

    public static TM1Level findLevel(TM1Cube cube, String mddsLUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(null, cube, mddsLUN);
        if (null == metadata || TM1MetadataType.LEVEL != metadata.getType()) {
            if (mustResolve) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_LevelNotFound, (Object)mddsLUN);
            }
            return null;
        }
        return (TM1Level)metadata;
    }

    public static TM1Member findMember(TM1MetadataSession session, TM1Cube cube, String mddsMUN, boolean mustResolve) throws TM1Exception {
        TM1Metadata metadata = TM1Utils.findMetadata(session, cube, mddsMUN);
        if (null == metadata || TM1MetadataType.MEMBER != metadata.getType()) {
            if (mustResolve) {
                throw new QLSRuntimeException(TM1MessageKeys.MET_MemberNotFound, (Object)mddsMUN);
            }
            return null;
        }
        return (TM1Member)metadata;
    }

    public static Locale resolveProductLocale(IQueryContext queryContext) {
        Locale resolvedLocale = null;
        if (null != queryContext) {
            resolvedLocale = queryContext.getProductLocale();
        } else {
            ISession session = LocalSessionContext.get();
            if (null != session) {
                resolvedLocale = session.getProductLocale();
            }
        }
        if (null == resolvedLocale) {
            return Locale.getDefault();
        }
        return resolvedLocale;
    }

    public static IDataType convertFieldTypeToDataType(FieldType fieldType) {
        switch (fieldType) {
            case Boolean: {
                return DataTypes.getBooleanType();
            }
            case Double: {
                return DataTypes.getDoubleType();
            }
            case Integer: {
                return DataTypes.getLongType();
            }
        }
        return DataTypes.getStringType((int)Integer.MAX_VALUE);
    }

    public static boolean isValidExcelDate(double dValue) {
        return dValue > -4.9E-324;
    }

    private static Calendar getCalendar() {
        Calendar calendar = GREGORIAN_CALENDAR.get();
        if (null == calendar) {
            calendar = new GregorianCalendar();
            GREGORIAN_CALENDAR.set(calendar);
        } else {
            calendar.clear();
        }
        return calendar;
    }

    public static Date convertExcelDate(double serialDate) {
        if (!TM1Utils.isValidExcelDate(serialDate)) {
            return null;
        }
        Calendar calendar = TM1Utils.getCalendar();
        int wholeDays = (int)Math.floor(serialDate);
        int millisecondsInDay = (int)((serialDate - (double)wholeDays) * 8.64E7 + 0.5);
        int dayAdjust = -1;
        if (wholeDays < 61) {
            dayAdjust = 0;
        }
        calendar.set(1900, 0, wholeDays + dayAdjust, 0, 0, 0);
        calendar.set(14, millisecondsInDay);
        return calendar.getTime();
    }

    public static boolean hasDateFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.contains("yy");
    }

    public static boolean hasTimeFormatting(String formatString) {
        if (formatString == null || formatString.length() == 0) {
            return false;
        }
        return formatString.contains("h");
    }
}

