/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.olap.tm1.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class TraceObject {
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final int INDENT_SIZE = 2;
    private final String mName;
    private Map<String, Object> mFields = new LinkedHashMap<String, Object>();
    private final List<TraceObject> mChildren = new LinkedList<TraceObject>();

    public TraceObject(String name) {
        this.mName = name;
    }

    public void setAttribute(String name, Object value) {
        this.mFields.put(name, value);
    }

    public void addChild(TraceObject child) {
        this.mChildren.add(child);
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    public void render(StringBuilder sb) {
        this.render(sb, 0);
    }

    public void render(StringBuilder sb, int indent) {
        TraceObject.print(sb, indent, this.mName);
        TraceObject.println(sb, 0, " {");
        for (Map.Entry<String, Object> e : this.mFields.entrySet()) {
            String fieldName = e.getKey();
            Object fieldValue = e.getValue();
            TraceObject.printf(sb, indent + 2, "+ %s = ", fieldName);
            if (fieldValue instanceof TraceObject) {
                TraceObject.println(sb);
                ((TraceObject)fieldValue).render(sb, indent + 2);
            } else {
                TraceObject.print(sb, 0, String.valueOf(fieldValue));
            }
            TraceObject.println(sb);
        }
        for (TraceObject child : this.mChildren) {
            child.render(sb, indent + 4);
            TraceObject.println(sb);
        }
        TraceObject.println(sb, indent, "}");
    }

    private static void print(StringBuilder sb, int indent, String str) {
        TraceObject.indent(sb, indent);
        sb.append(str);
    }

    private static void println(StringBuilder sb) {
        sb.append(NEWLINE);
    }

    private static void println(StringBuilder sb, int indent, String str) {
        TraceObject.indent(sb, indent);
        sb.append(str).append(NEWLINE);
    }

    private static void printf(StringBuilder sb, int indent, String format, Object ... args) {
        TraceObject.indent(sb, indent);
        sb.append(String.format(format, args));
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
    }
}

