/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.qls.query.provider.relational.monetdb;

import com.ibm.cognos.aurora.api.model.IConnectionSpec;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.IDataItemStats;
import com.ibm.cognos.aurora.api.model.IDataSource;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.IQueryContext;
import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import com.ibm.cognos.aurora.api.query.LocalSessionContext;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.api.query.provider.connection.IExpirationPolicy;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnection;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionFactory;
import com.ibm.cognos.aurora.api.query.provider.connection.IProviderConnectionPool;
import com.ibm.cognos.aurora.api.query.provider.tabular.ICatalogRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.IColumnRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ICrossReferenceRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.IPrimaryKeyRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ISchemaRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITableRecord;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularDataProvider;
import com.ibm.cognos.aurora.api.query.provider.tabular.ITabularResultSet;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.model.DataItemStats;
import com.ibm.cognos.aurora.qls.exception.QLSMessageKeys;
import com.ibm.cognos.aurora.qls.exception.QLSRuntimeException;
import com.ibm.cognos.aurora.qls.query.QueryContext;
import com.ibm.cognos.aurora.qls.query.provider.FieldIndex;
import com.ibm.cognos.aurora.qls.query.provider.connection.ProviderConnectionPool;
import com.ibm.cognos.aurora.qls.query.provider.connection.SimpleExpirationPolicy;
import com.ibm.cognos.aurora.qls.query.provider.relational.JDBCProviderConnection;
import com.ibm.cognos.aurora.qls.query.provider.relational.JDBCTabularResultSet;
import com.ibm.cognos.aurora.qls.query.provider.relational.metadata.CatalogRecord;
import com.ibm.cognos.aurora.qls.query.provider.relational.metadata.ColumnRecord;
import com.ibm.cognos.aurora.qls.query.provider.relational.metadata.CrossReferenceRecord;
import com.ibm.cognos.aurora.qls.query.provider.relational.metadata.PrimaryKeyRecord;
import com.ibm.cognos.aurora.qls.query.provider.relational.metadata.SchemaRecord;
import com.ibm.cognos.aurora.qls.query.provider.relational.metadata.TableRecord;
import com.ibm.cognos.aurora.qls.query.provider.relational.monetdb.MonetDBConnection;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;

public class MonetDBDataProvider
implements ITabularDataProvider {
    public static final String PROVIDER_TYPE = "monetdb";
    private IQueryLogicalStorage mQLS = null;
    private ConnectionFactory mConnFactory;
    private ProviderConnectionPool mConnPool;
    private final AtomicBoolean mDisposed = new AtomicBoolean(false);
    private static final ILogger logger = LoggerManager.getLogger((String)"ATHENA.core.qls_providers");

    public IProviderConnectionFactory getConnectionFactory() {
        return this.mConnFactory;
    }

    public IProviderConnectionPool getConnectionPool() {
        return this.mConnPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDataSource(IDataSource dataSource) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        try {
            connection.validate();
        }
        finally {
            connection.returnToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICatalogRecord> discoverCatalogs(IDataSource dataSource) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        Connection jdbcConnection = connection.getJDBCConnection();
        try {
            List<ICatalogRecord> list;
            DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
            ResultSet rs = dbMetadata.getCatalogs();
            try {
                list = this.getCatalogsFromResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
                }
            }
            rs.close();
            return list;
        }
        finally {
            connection.returnToPool();
        }
    }

    private List<ICatalogRecord> getCatalogsFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<ICatalogRecord> records = new ArrayList<ICatalogRecord>();
        FieldIndex fieldIndex = new FieldIndex();
        while (rs.next()) {
            CatalogRecord rec = new CatalogRecord(fieldIndex);
            rec.setCatalogName(rs.getString("TABLE_CAT"));
            records.add((ICatalogRecord)rec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ISchemaRecord> discoverSchemas(IDataSource dataSource) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        Connection jdbcConnection = connection.getJDBCConnection();
        try {
            List<ISchemaRecord> list;
            DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
            ResultSet rs = dbMetadata.getSchemas();
            try {
                list = this.getSchemasFromResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
                }
            }
            rs.close();
            return list;
        }
        finally {
            connection.returnToPool();
        }
    }

    private List<ISchemaRecord> getSchemasFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<ISchemaRecord> records = new ArrayList<ISchemaRecord>();
        FieldIndex fieldIndex = new FieldIndex();
        while (rs.next()) {
            SchemaRecord rec = new SchemaRecord(fieldIndex);
            rec.setCatalogName(rs.getString("TABLE_CATALOG"));
            rec.setSchemaName(rs.getString("TABLE_SCHEM"));
            records.add((ISchemaRecord)rec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITableRecord> discoverTables(IDataSource dataSource, String catalogName, String schemaName, String tableName, String[] tableTypes) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        Connection jdbcConnection = connection.getJDBCConnection();
        try {
            List<ITableRecord> list;
            DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
            ResultSet rs = dbMetadata.getTables(catalogName, schemaName, tableName, tableTypes);
            try {
                list = this.getTablesFromResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
                }
            }
            rs.close();
            return list;
        }
        finally {
            connection.returnToPool();
        }
    }

    private List<ITableRecord> getTablesFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<ITableRecord> records = new ArrayList<ITableRecord>();
        FieldIndex fieldIndex = new FieldIndex();
        while (rs.next()) {
            TableRecord rec = new TableRecord(fieldIndex);
            rec.setCatalogName(rs.getString("TABLE_CAT"));
            rec.setSchemaName(rs.getString("TABLE_SCHEM"));
            rec.setTableName(rs.getString("TABLE_NAME"));
            rec.setTableType(rs.getString("TABLE_TYPE"));
            rec.setRemarks(rs.getString("REMARKS"));
            records.add((ITableRecord)rec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IColumnRecord> discoverColumns(IDataSource dataSource, String catalogName, String schemaName, String tableName, String columnName) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        Connection jdbcConnection = connection.getJDBCConnection();
        try {
            List<IColumnRecord> list;
            DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
            ResultSet rs = dbMetadata.getColumns(catalogName, schemaName, tableName, columnName);
            try {
                list = this.getColumnsFromResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
                }
            }
            rs.close();
            return list;
        }
        finally {
            connection.returnToPool();
        }
    }

    private List<IColumnRecord> getColumnsFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<IColumnRecord> records = new ArrayList<IColumnRecord>();
        FieldIndex fieldIndex = new FieldIndex();
        while (rs.next()) {
            ColumnRecord rec = new ColumnRecord(fieldIndex);
            rec.setCatalogName(rs.getString("TABLE_CAT"));
            rec.setSchemaName(rs.getString("TABLE_SCHEM"));
            rec.setTableName(rs.getString("TABLE_NAME"));
            rec.setColumnName(rs.getString("COLUMN_NAME"));
            rec.setSQLDataType(rs.getInt("DATA_TYPE"));
            rec.setTypeName(rs.getString("TYPE_NAME"));
            rec.setColumnSize(rs.getInt("COLUMN_SIZE"));
            rec.setNullable(rs.getInt("NULLABLE"));
            rec.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
            rec.setRemarks(rs.getString("REMARKS"));
            records.add((IColumnRecord)rec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IPrimaryKeyRecord> discoverPrimaryKeys(IDataSource dataSource, String catalogName, String schemaName, String tableName) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        Connection jdbcConnection = connection.getJDBCConnection();
        try {
            List<IPrimaryKeyRecord> list;
            DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
            ResultSet rs = dbMetadata.getPrimaryKeys(catalogName, schemaName, tableName);
            try {
                list = this.getPrimaryKeysFromResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
                }
            }
            rs.close();
            return list;
        }
        finally {
            connection.returnToPool();
        }
    }

    private List<IPrimaryKeyRecord> getPrimaryKeysFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<IPrimaryKeyRecord> records = new ArrayList<IPrimaryKeyRecord>();
        FieldIndex fieldIndex = new FieldIndex();
        while (rs.next()) {
            PrimaryKeyRecord rec = new PrimaryKeyRecord(fieldIndex);
            rec.setCatalogName(rs.getString("TABLE_CAT"));
            rec.setSchemaName(rs.getString("TABLE_SCHEM"));
            rec.setTableName(rs.getString("TABLE_NAME"));
            rec.setColumnName(rs.getString("COLUMN_NAME"));
            rec.setKeySequenceNumber(rs.getShort("KEY_SEQ"));
            rec.setPKName(rs.getString("PK_NAME"));
            records.add((IPrimaryKeyRecord)rec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICrossReferenceRecord> discoverCrossReferences(IDataSource dataSource, String primaryCatalogName, String primarySchemaName, String primaryTableName, String foreignCatalogName, String foreignSchemaName, String foreignTableName) {
        MonetDBConnection connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
        Connection jdbcConnection = connection.getJDBCConnection();
        try {
            List<ICrossReferenceRecord> list;
            DatabaseMetaData dbMetadata = jdbcConnection.getMetaData();
            ResultSet rs = dbMetadata.getCrossReference(primaryCatalogName, primarySchemaName, primaryTableName, foreignCatalogName, foreignSchemaName, foreignTableName);
            try {
                list = this.getCrossReferencesFromResultSet(rs);
            }
            catch (Throwable throwable) {
                try {
                    rs.close();
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
                }
            }
            rs.close();
            return list;
        }
        finally {
            connection.returnToPool();
        }
    }

    private List<ICrossReferenceRecord> getCrossReferencesFromResultSet(ResultSet rs) throws SQLException {
        ArrayList<ICrossReferenceRecord> records = new ArrayList<ICrossReferenceRecord>();
        FieldIndex fieldIndex = new FieldIndex();
        while (rs.next()) {
            CrossReferenceRecord rec = new CrossReferenceRecord(fieldIndex);
            rec.setPKCatalogName(rs.getString("PKTABLE_CAT"));
            rec.setPKSchemaName(rs.getString("PKTABLE_SCHEM"));
            rec.setPKTableName(rs.getString("PKTABLE_NAME"));
            rec.setPKColumnName(rs.getString("PKCOLUMN_NAME"));
            rec.setPKName(rs.getString("PK_NAME"));
            rec.setFKCatalogName(rs.getString("FKTABLE_CAT"));
            rec.setFKSchemaName(rs.getString("FKTABLE_SCHEM"));
            rec.setFKTableName(rs.getString("FKTABLE_NAME"));
            rec.setFKColumnName(rs.getString("FKCOLUMN_NAME"));
            rec.setFKName(rs.getString("FK_NAME"));
            rec.setKeySequenceNumber(rs.getShort("KEY_SEQ"));
            records.add((ICrossReferenceRecord)rec);
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValueIterator queryColumnValues(IDataSource dataSource, String schemaName, String tableName, String columnName, boolean distinct, long limit) {
        StringBuilder sqlBuf = new StringBuilder();
        sqlBuf.append("SELECT ");
        if (distinct) {
            sqlBuf.append("DISTINCT ");
        }
        sqlBuf.append("\"").append(columnName).append("\" FROM \"");
        if (null != schemaName && !schemaName.isEmpty()) {
            sqlBuf.append(schemaName).append("\".\"");
        }
        sqlBuf.append(tableName).append("\"");
        if (limit > 0L) {
            sqlBuf.append(" LIMIT ").append(Long.toString(limit));
        }
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        try {
            final ITabularResultSet resultSet = this.query(dataSource, sqlBuf.toString(), (IQueryContext)queryContext);
            IValueIterator iValueIterator = new IValueIterator(){
                private final ITabularResultSet mResultSet;
                {
                    this.mResultSet = resultSet;
                }

                public IValue next() {
                    if (!this.mResultSet.hasMore()) {
                        return null;
                    }
                    return this.mResultSet.nextRow()[0];
                }

                public boolean hasNext() {
                    return this.mResultSet.hasMore();
                }

                public void reset() {
                    this.mResultSet.reset();
                }

                public void close() {
                    this.mResultSet.close();
                }
            };
            return iValueIterator;
        }
        finally {
            queryContext.terminate();
        }
    }

    public ITabularResultSet query(IDataSource dataSource, String sql, IQueryContext queryContext) {
        MonetDBConnection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        boolean failed = false;
        try {
            connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
            statement = connection.getJDBCConnection().createStatement();
            rs = statement.executeQuery(sql);
            JDBCTabularResultSet jDBCTabularResultSet = new JDBCTabularResultSet((JDBCProviderConnection)connection, queryContext, statement, rs);
            return jDBCTabularResultSet;
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::query()");
            failed = true;
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
        catch (RuntimeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::query()");
            failed = true;
            throw ex;
        }
        finally {
            if (failed) {
                try {
                    if (null != rs) {
                        rs.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::query()", (Throwable)ex);
                }
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::query()", (Throwable)ex);
                }
                if (null != connection) {
                    connection.returnToPool();
                }
            }
        }
    }

    public int[] update(IDataSource dataSource, String updateString, List<List<Object>> allBindVars, IQueryContext queryContext) {
        MonetDBConnection connection = null;
        Statement statement = null;
        boolean failed = false;
        try {
            connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
            connection.getJDBCConnection().setAutoCommit(false);
            statement = connection.getJDBCConnection().prepareStatement(updateString);
            if (allBindVars.isEmpty()) {
                statement.addBatch();
            } else {
                for (int i = 0; i < allBindVars.size(); ++i) {
                    List<Object> bindVars = allBindVars.get(i);
                    for (int j = 0; j < bindVars.size(); ++j) {
                        if (bindVars.get(j) == null) {
                            statement.setNull(j + 1, MonetDBDataProvider.convertJavaTypeToJdbcType(allBindVars.get(i + 1).get(j).getClass()));
                            continue;
                        }
                        statement.setObject(j + 1, bindVars.get(j), MonetDBDataProvider.convertJavaTypeToJdbcType(bindVars.get(j).getClass()));
                    }
                    statement.addBatch();
                }
            }
            int[] updateResults = statement.executeBatch();
            connection.getJDBCConnection().commit();
            int[] nArray = updateResults;
            return nArray;
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()");
            failed = true;
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
        catch (RuntimeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()");
            failed = true;
            throw ex;
        }
        finally {
            if (failed) {
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()", (Throwable)ex);
                }
                try {
                    if (null != connection) {
                        connection.getJDBCConnection().rollback();
                    }
                }
                catch (SQLException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()", (Throwable)ex);
                }
                if (null != connection) {
                    connection.invalidate();
                }
            }
        }
    }

    public int update(IDataSource dataSource, String queryString, IQueryContext queryContext) {
        MonetDBConnection connection = null;
        Statement statement = null;
        boolean failed = false;
        try {
            connection = (MonetDBConnection)this.getConnectionPool().borrow(dataSource.getConnectionSpec());
            connection.getJDBCConnection().setAutoCommit(false);
            statement = connection.getJDBCConnection().createStatement();
            statement.addBatch(queryString);
            int[] result = statement.executeBatch();
            connection.getJDBCConnection().commit();
            int n = result[0];
            return n;
        }
        catch (SQLException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()");
            failed = true;
            throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
        }
        catch (RuntimeException ex) {
            logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()");
            failed = true;
            throw ex;
        }
        finally {
            if (failed) {
                try {
                    if (null != statement) {
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()", (Throwable)ex);
                }
                try {
                    if (null != connection) {
                        connection.getJDBCConnection().rollback();
                    }
                }
                catch (SQLException ex) {
                    logger.error(ex.getLocalizedMessage(), this.getClass().getName() + "::update()", (Throwable)ex);
                }
                if (null != connection) {
                    connection.invalidate();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDataItemStats fetchDataItemStats(IDataItem dataItem) {
        IRelColumn relCol = (IRelColumn)dataItem.getPhysicalMetadata();
        IRelTable relTable = relCol.getTable();
        String schemaName = relTable.getSchemaName();
        String tableName = relTable.getTableName();
        String columnName = relCol.getColumnName();
        StringBuilder sqlBuf = new StringBuilder();
        sqlBuf.append("SELECT COUNT(DISTINCT \"");
        sqlBuf.append(columnName).append("\") AS \"DISTINCT_COUNT\"").append(", COUNT(*) as \"TOTAL_COUNT\"").append(", COUNT(\"").append(columnName).append("\") as \"NON_NULL_COUNT\"").append(", MIN(\"").append(columnName).append("\") as \"MIN\"").append(", MAX(\"").append(columnName).append("\") as \"MAX\"").append(" FROM \"");
        if (null != schemaName && schemaName.length() > 0) {
            sqlBuf.append(schemaName).append("\".\"");
        }
        sqlBuf.append(tableName).append("\"");
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        try {
            DataItemStats dataItemStats;
            ITabularResultSet resultSet = this.query(relTable.getModel().getDataSource(), sqlBuf.toString(), (IQueryContext)queryContext);
            try {
                DataItemStats stats = new DataItemStats();
                if (resultSet.hasMore()) {
                    IValue[] row = resultSet.nextRow();
                    stats.setDistinctCount(row[0].longValue());
                    long totalCount = row[1].longValue();
                    stats.setCount(row[2].longValue());
                    stats.setNullCount(totalCount - stats.count());
                    stats.setMinValue(row[3]);
                    stats.setMaxValue(row[4]);
                    stats.setNullable(stats.count() < totalCount);
                    stats.setDensity((float)stats.count() / (float)totalCount);
                }
                dataItemStats = stats;
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return dataItemStats;
        }
        finally {
            queryContext.terminate();
        }
    }

    public IValueIterator fetchDataItemValues(IDataItem dataItem, boolean distinct) {
        return this.fetchDataItemValues(dataItem, distinct, -1L);
    }

    public IValueIterator fetchDataItemValues(IDataItem dataItem, boolean distinct, long limit) {
        IRelColumn relCol = (IRelColumn)dataItem.getPhysicalMetadata();
        IRelTable relTable = relCol.getTable();
        String schemaName = relTable.getSchemaName();
        String tableName = relTable.getTableName();
        String columnName = relCol.getColumnName();
        return this.queryColumnValues(relTable.getModel().getDataSource(), schemaName, tableName, columnName, distinct, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long fetchDistinctTupleCount(IDataItem[] dataItems) {
        String tableAlias;
        if (dataItems.length == 0) {
            return 0L;
        }
        StringBuilder sqlBuf = new StringBuilder();
        ArrayList<IRelTable> tables = new ArrayList<IRelTable>();
        ArrayList<IRelColumn> cols = new ArrayList<IRelColumn>();
        for (IDataItem di : dataItems) {
            IRelColumn relCol = (IRelColumn)di.getPhysicalMetadata();
            IRelTable relTable = relCol.getTable();
            if (!tables.contains(relTable)) {
                tables.add(relTable);
            }
            cols.add(relCol);
        }
        if (tables.size() > 2) {
            throw new UnsupportedOperationException("Tuples cannot span multiple tables.");
        }
        sqlBuf.append("SELECT COUNT(*) AS distinct_count FROM ( SELECT DISTINCT ");
        boolean first = true;
        for (IRelColumn col : cols) {
            IRelTable table = col.getTable();
            int tableIdx = tables.indexOf(table);
            tableAlias = "t" + tableIdx;
            if (first) {
                first = false;
            } else {
                sqlBuf.append(", ");
            }
            sqlBuf.append("\"").append(tableAlias).append("\".\"");
            sqlBuf.append(col.getColumnName()).append("\"");
        }
        sqlBuf.append(" FROM ");
        first = true;
        for (int tableIdx = 0; tableIdx < tables.size(); ++tableIdx) {
            IRelTable table = (IRelTable)tables.get(tableIdx);
            String schemaName = table.getSchemaName();
            String tableName = table.getTableName();
            tableAlias = "t" + tableIdx;
            if (first) {
                first = false;
            } else {
                sqlBuf.append(", ");
            }
            if (null != schemaName && schemaName.length() > 0) {
                sqlBuf.append("\"").append(schemaName).append("\".");
            }
            sqlBuf.append("\"").append(tableName).append("\" \"");
            sqlBuf.append(tableAlias).append("\"");
        }
        sqlBuf.append(" ) AS distinct_tuples");
        QueryContext queryContext = new QueryContext(LocalSessionContext.get());
        try {
            long l;
            ITabularResultSet resultSet = this.query(((IRelTable)tables.get(0)).getModel().getDataSource(), sqlBuf.toString(), (IQueryContext)queryContext);
            try {
                IValue[] row = resultSet.nextRow();
                l = row[0].longValue();
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return l;
        }
        finally {
            queryContext.terminate();
        }
    }

    public void initialize(IQueryLogicalStorage qls, Properties props) throws Exception {
        this.mQLS = qls;
        Class.forName("nl.cwi.monetdb.jdbc.MonetDriver");
        this.mConnFactory = new ConnectionFactory();
        this.mConnPool = new ProviderConnectionPool("MonetDBConnectionPool", (IProviderConnectionFactory)this.mConnFactory, (IExpirationPolicy)new SimpleExpirationPolicy(600000L));
        this.mQLS.getConnectionPoolManager().registerPool((IProviderConnectionPool)this.mConnPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.mDisposed.compareAndSet(false, true)) {
            if (null != this.mConnPool) {
                try {
                    this.mQLS.getConnectionPoolManager().unregisterPool((IProviderConnectionPool)this.mConnPool);
                    this.mConnPool.shutdown();
                }
                finally {
                    this.mConnPool = null;
                }
            }
            this.mQLS = null;
        }
    }

    private Connection createJDBCConnection(IConnectionSpec connSpec) throws SQLException {
        String connectionString = connSpec.getParameterStringValue("jdbcConnectionString");
        String user = connSpec.getParameterStringValue("user");
        String password = connSpec.getParameterStringValue("password");
        return DriverManager.getConnection(connectionString, user, password);
    }

    public static int convertJavaTypeToJdbcType(Class<?> classType) {
        if (classType == Integer.class) {
            return 5;
        }
        if (classType == Character.class) {
            return 1;
        }
        if (classType == BigDecimal.class) {
            return 2;
        }
        if (classType == Double.class) {
            return 8;
        }
        if (classType == Date.class || classType == java.util.Date.class) {
            return 91;
        }
        if (classType == String.class) {
            return 12;
        }
        if (classType == Long.class) {
            return -5;
        }
        if (classType == Float.class) {
            return 7;
        }
        if (classType == Boolean.class) {
            return -7;
        }
        if (classType == byte[].class || classType == Blob.class) {
            return 2004;
        }
        if (classType == Clob.class) {
            return 2005;
        }
        if (classType == Timestamp.class) {
            return 93;
        }
        if (classType == Short.class) {
            return 5;
        }
        throw new IllegalArgumentException("Unsupported Java type: " + classType.getName());
    }

    private final class ConnectionFactory
    implements IProviderConnectionFactory {
        private ConnectionFactory() {
        }

        public IProviderConnection create(IConnectionSpec connSpec) {
            try {
                Connection jdbcConn = MonetDBDataProvider.this.createJDBCConnection(connSpec);
                return new MonetDBConnection(MonetDBDataProvider.this, jdbcConn, connSpec);
            }
            catch (SQLException ex) {
                throw new QLSRuntimeException(QLSMessageKeys.PRV_JDBCError, (Throwable)ex, (Object)ex.getErrorCode(), (Object)ex.getSQLState(), (Object)ex.getMessage());
            }
        }
    }
}

