/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.RequestCreator;
import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.data.RecordingDecorator;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.ChartInsights;
import com.ibm.bi.predict.explore.nlt.deriveddata.DerivedDataProcessor;
import com.ibm.bi.predict.explore.nlt.framework.Filter;
import com.ibm.bi.predict.explore.nlt.framework.Filtering;
import com.ibm.bi.predict.explore.nlt.framework.ProcessorResults;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.InsightsProcessor;
import com.ibm.bi.predict.explore.nlt.insights.postprocessors.PredictiveStrengthPostProcessor;
import com.ibm.bi.predict.explore.nlt.insights.postprocessors.RemoveDuplicateInsights;
import com.ibm.bi.predict.explore.nlt.insights.postprocessors.SpecialCasesFilter;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.service.PredictServiceRequest;
import com.ibm.bi.predict.service.PredictServiceResponse;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONObject;

public class ChartInsightService
implements PredictServiceFramework {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ChartInsightService.class);

    public PredictServiceResponse run(Collection<PredictServiceRequest> requests, Locale locale) {
        if (!ChartInsightService.validRequests(requests)) {
            throw new IllegalArgumentException("Invalid list of requests");
        }
        return this.runAll(requests.stream().map(ChartInsightService::convertRequest).collect(Collectors.toList()));
    }

    public ChartInsights runAll(List<Request> requests) {
        if (requests == null) {
            throw new IllegalArgumentException("ChartInsightService: List of requests was null");
        }
        ChartInsights all = new ChartInsights(requests.get(0));
        requests.forEach(request -> all.merge(this.run((Request)request)));
        return all;
    }

    public ChartInsights run(Request request) {
        LOGGER.debug("Start to run chart insight service");
        if (request == null) {
            throw new IllegalArgumentException("ChartInsightService: Request was null");
        }
        if (request.get(Locale.class) == null) {
            throw new IllegalArgumentException("ChartInsightService: Locale was null");
        }
        Request newParams = request.getOpt(DataAccessProvider.class).map(p -> ChartInsightService.wrapDecoratorWithRecording(request, p)).orElse(request);
        return this.runRequest(newParams);
    }

    static Request convertRequest(PredictServiceRequest request) {
        DataAccessProvider provider = request.getData().asDataAccessProvider();
        ChartInsightsContext context = (ChartInsightsContext)request.getContext();
        JSONObject tree = context.getTree();
        Locale locale = request.getLocale();
        if (provider != null) {
            return RequestCreator.create(provider, context, locale);
        }
        if (tree != null) {
            return RequestCreator.create(tree, locale);
        }
        throw new IllegalArgumentException("Illegal request, data access provider and tree are both null");
    }

    private static Request wrapDecoratorWithRecording(Request request, DataAccessProvider p) {
        return RequestCreator.create(RecordingDecorator.makeProviderWithBaseDecorator(p), request.get(ChartInsightsContext.class), request.get(Locale.class));
    }

    protected List<Filter<ChartInsight>> getPostProcessors() {
        return Arrays.asList(new PredictiveStrengthPostProcessor(), new SpecialCasesFilter(), new RemoveDuplicateInsights());
    }

    private ChartInsights runRequest(Request request) {
        LOGGER.perfStart();
        LOGGER.perfLog("ChartInsightService called");
        if (this.isClippedData(request)) {
            LOGGER.debug("Not generating insights due to clipped data");
            LOGGER.perfStop();
            return this.getClippedDataInsight(request);
        }
        ChartInsightsContext context = request.get(ChartInsightsContext.class);
        ProcessorResults requests = new DerivedDataProcessor(context).process(request);
        requests.content().add(0, request);
        LOGGER.perfLog("Requests generated, running {} requests", (Object)requests.content().size());
        ProcessorResults<ChartInsight> insightList = new InsightsProcessor(context).process(requests.content());
        insightList.addMessagesFrom(requests);
        LOGGER.perfLog("Insights generated, {} insights", (Object)insightList.content().size());
        Filtering<ChartInsight> pp = new Filtering<ChartInsight>(this.getPostProcessors());
        pp.process(insightList);
        ChartInsights insights = new ChartInsights(insightList, request);
        LOGGER.perfStop("Post-processing complete, " + insights.content().size() + " insights");
        return insights;
    }

    private boolean isClippedData(Request request) {
        Optional<DataAccessProvider> dap = request.getOpt(DataAccessProvider.class);
        if (dap.isPresent()) {
            return dap.get().getMetaData().isClippedData();
        }
        return false;
    }

    private ChartInsights getClippedDataInsight(Request request) {
        String key = "INSIGHTS_CLIPPED_DATA";
        String type = "INSIGHTS_NONE";
        String bundleName = "Predict_Insights";
        Messages messages = Messages.getMessagesFor((String)bundleName, (Locale)request.get(Locale.class));
        ChartInsight insight = new ChartInsight(request, messages.get(key, new Object[0]), new JSONObject(), Tag.getTags(type), type, InsightSemantics.empty());
        ProcessorResults<ChartInsight> results = new ProcessorResults<ChartInsight>();
        results.addAll(Arrays.asList(insight));
        return new ChartInsights(results, request);
    }

    private static boolean validRequests(Collection<PredictServiceRequest> requests) {
        return requests != null && requests.stream().allMatch(Objects::nonNull);
    }
}

