/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.thirdparty.smarts.SmartsService;
import com.ibm.bi.predict.types.DataItemType;
import com.ibm.bi.predict.types.RoleType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.json.JSONObject;

public class ChartInsightsContext
extends Context {
    public static final String DO_SMART_ANNOTATIONS = "insights-config.do_smart_annotations";
    public static final String DO_REAGGREGATION = "insights-config.do_reaggregation";
    public static final String MODULE_ID = "moduleId";
    public static final String SHAPED_MODULE = "shapedModule";
    public static final String TEMP_MODULE = "tempModule";
    private final Map<String, RoleType> roleMap = new HashMap<String, RoleType>();
    private final Map<String, DataItemType> typesMap = new HashMap<String, DataItemType>();
    private JSONObject tree = null;
    private SmartsService smartsService;

    public ChartInsightsContext setRoles(Map<String, RoleType> roleMap) {
        this.roleMap.clear();
        this.roleMap.putAll(roleMap);
        return this;
    }

    public ChartInsightsContext setTypes(Map<String, DataItemType> typesMap) {
        this.typesMap.clear();
        this.typesMap.putAll(typesMap);
        return this;
    }

    public Set<String> keySet() {
        return this.roleMap.keySet();
    }

    public boolean hasRole(String dataItemId) {
        return this.roleMap.containsKey(dataItemId);
    }

    public RoleType getRole(String dataItemId) {
        return this.roleMap.getOrDefault(dataItemId, RoleType.OTHER);
    }

    public DataItemType getType(String dataItemId) {
        return this.typesMap.getOrDefault(dataItemId, null);
    }

    public ChartInsightsContext doSmartAnnotations(boolean doSmartAnnotations) {
        this.setValue(DO_SMART_ANNOTATIONS, doSmartAnnotations);
        return this;
    }

    public boolean doSmartAnnotations() {
        return this.getBoolean(DO_SMART_ANNOTATIONS, true);
    }

    public ChartInsightsContext doReaggregation(boolean doReaggregation) {
        this.setValue(DO_REAGGREGATION, doReaggregation);
        return this;
    }

    public boolean doReaggregation() {
        return this.getBoolean(DO_REAGGREGATION, true);
    }

    public ChartInsightsContext setTree(JSONObject tree) {
        this.tree = tree;
        return this;
    }

    public JSONObject getTree() {
        return this.tree;
    }

    public ChartInsightsContext setModuleId(String moduleId) {
        this.setValue(MODULE_ID, moduleId);
        return this;
    }

    public String getModuleId() {
        return this.getString(MODULE_ID, null);
    }

    public ChartInsightsContext setTempModule(String module) {
        this.setValue(TEMP_MODULE, module);
        return this;
    }

    public String getTempModule() {
        return this.getString(TEMP_MODULE, null);
    }

    public ChartInsightsContext setSmartsService(SmartsService smartsService) {
        this.smartsService = smartsService;
        return this;
    }

    public SmartsService getSmartsService() {
        return this.smartsService;
    }

    public ChartInsightsContext setShapedModule(boolean shapedModule) {
        this.setValue(SHAPED_MODULE, shapedModule);
        return this;
    }

    public Boolean getShapedModule() {
        return this.getBoolean(SHAPED_MODULE, false);
    }
}

