/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.dataaccess.json.JsonHelpers;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.types.DataItemType;
import com.ibm.bi.predict.types.RoleType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ChartInsightsContextFactory
implements PredictContextFactory {
    public static final String DICTIONARY_KEY = "dictionary";
    public static final String DATAITEMS_KEY = "dataItems";
    public static final String ROLES_KEY = "roles";
    public static final String DATA_ITEM_TYPES_KEY = "dataItemsTypes";
    public static final String MODULE_ID_KEY = "moduleAssetId";
    public static final String TEMP_MODULE_KEY = "tempModule";
    public static final String SHAPED_MODULE_KEY = "shapedModule";

    public Context make(JSONObject parameters) throws JSONException {
        return ChartInsightsContextFactory.makeFromJson(parameters);
    }

    public static ChartInsightsContext create(Map<String, RoleType> roleMap, boolean doSmartAnnotations) {
        ChartInsightsContext derived = new ChartInsightsContext();
        derived.setRoles(roleMap);
        derived.doSmartAnnotations(doSmartAnnotations);
        return derived;
    }

    public static ChartInsightsContext makeFromJson(JSONObject parameters) {
        JSONObject dictionary = JsonHelpers.getObject((JSONObject)parameters, (String)DICTIONARY_KEY);
        List dataItems = JsonHelpers.getStringList((JSONObject)dictionary, (String)DATAITEMS_KEY);
        List roles = JsonHelpers.getStringList((JSONObject)dictionary, (String)ROLES_KEY);
        Optional moduleId = JsonHelpers.optString((JSONObject)dictionary, (String)MODULE_ID_KEY);
        Optional tempModule = JsonHelpers.optString((JSONObject)dictionary, (String)TEMP_MODULE_KEY);
        boolean shapedModule = false;
        if (dictionary.containsKey((Object)SHAPED_MODULE_KEY)) {
            shapedModule = JsonHelpers.getBoolean((JSONObject)dictionary, (String)SHAPED_MODULE_KEY);
        }
        if (dataItems.size() != roles.size()) {
            throw new IllegalArgumentException("dataItems and roles are not the same length");
        }
        HashMap<String, RoleType> roleMap = new HashMap<String, RoleType>();
        for (int i = 0; i < dataItems.size(); ++i) {
            String id = (String)dataItems.get(i);
            RoleType r = RoleType.fromString((String)((String)roles.get(i)));
            if (r == null) {
                throw new IllegalArgumentException("Unknown role '" + (String)roles.get(i) + "'");
            }
            roleMap.put(id, r);
        }
        return new ChartInsightsContext().setRoles(roleMap).setTypes(ChartInsightsContextFactory.dataItemTypes(dictionary)).setModuleId(moduleId.orElse(null)).setShapedModule(shapedModule).setTempModule(tempModule.orElse(null));
    }

    private static Map<String, DataItemType> dataItemTypes(JSONObject dictionary) {
        List dataItems = JsonHelpers.getStringList((JSONObject)dictionary, (String)DATAITEMS_KEY);
        List dataItemTypes = JsonHelpers.optStringList((JSONObject)dictionary, (String)DATA_ITEM_TYPES_KEY);
        if (dataItems.size() != dataItemTypes.size()) {
            return Collections.emptyMap();
        }
        HashMap<String, DataItemType> typesMap = new HashMap<String, DataItemType>();
        for (int i = 0; i < dataItems.size(); ++i) {
            String id = (String)dataItems.get(i);
            DataItemType t = DataItemType.fromString((String)((String)dataItemTypes.get(i)));
            if (t == null) {
                throw new IllegalArgumentException("Unknown type '" + (String)dataItemTypes.get(i) + "'");
            }
            typesMap.put(id, t);
        }
        return typesMap;
    }
}

