/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.explore.ExploreContextFactory;
import com.ibm.bi.predict.explore.ExploreParams;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.json.JSONObject;

public class ExploreContext
extends DataContext {
    public static final String EXPLORE_PARAMS_REQUESTID = "explore-params.requestId";
    public static final String EXPLORE_PARAMS_CANDIDATES = "explore-params.candidates";
    public static final String EXPLORE_PARAMS_NNODES = "explore-params.nnodes";
    public static final String LOGGABLE_NAME_FOR_NULL = "'field name is null'";
    public static final String LOGGABLE_NAME_FOR_UNKNOWN = "'field name is unknown'";
    private List<ExploreParams.Grouping> groupings;

    public ExploreContext setGroupings(List<ExploreParams.Grouping> groupings) {
        this.groupings = groupings;
        return this;
    }

    public void loadDataContextProperties(JSONObject obj) {
        super.parseJson(obj);
    }

    public ExploreContext mixin(JSONObject params) {
        this.mixinParameters(params);
        this.setIfPresentString("target", params);
        this.setIfPresent("requestId", (Map)params);
        this.setMaxRelationships(params);
        this.setMinStrength(params);
        this.setCandidates(params);
        this.setGroupings(params);
        this.setNNodes(params);
        return this;
    }

    protected void setCandidates(JSONObject params) {
        this.setValue(EXPLORE_PARAMS_CANDIDATES, JsonUtils.getStringArray((JSONObject)params, (String)"candidates"));
    }

    private void setMaxRelationships(JSONObject params) {
        this.setValue("maxRelationships", JsonUtils.getOptionalInt((JSONObject)params, (String)"maxRelationships", (int)0));
    }

    private void setMinStrength(JSONObject params) {
        this.setValue("minStrength", JsonUtils.getOptionalDouble((JSONObject)params, (String)"minStrength", (double)0.1));
    }

    protected void setGroupings(JSONObject params) {
        this.groupings = ExploreContextFactory.getGroupings(params);
    }

    private void setNNodes(JSONObject params) {
        Optional nnodes;
        int nnv = JsonUtils.getOptionalInt((JSONObject)params, (String)"requestedItemCount", (int)-1);
        Optional<Object> optional = nnodes = nnv <= 0 ? Optional.empty() : Optional.of(nnv);
        if (nnodes.isPresent()) {
            this.setValue(EXPLORE_PARAMS_NNODES, nnodes.get());
        }
    }

    public String getExploreRequestId() {
        String requestId = this.getString("requestId", null);
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
            this.setValue("requestId", requestId);
        }
        return requestId;
    }

    public List<ExploreParams.Grouping> getGroupings() {
        return this.groupings;
    }

    public String getLoggableName(String name) {
        int i;
        if (name == null) {
            return LOGGABLE_NAME_FOR_NULL;
        }
        if (name.equals(this.getString("target", null))) {
            return "'target'";
        }
        List candidates = this.getStringList(EXPLORE_PARAMS_CANDIDATES, new ArrayList());
        for (i = 0; i < candidates.size(); ++i) {
            if (!name.equals(candidates.get(i))) continue;
            return "'candidate " + i + "'";
        }
        for (i = 0; i < this.groupings.size(); ++i) {
            if (!name.equals(this.groupings.get(i).getId())) continue;
            return "'grouping " + i + "'";
        }
        return LOGGABLE_NAME_FOR_UNKNOWN;
    }

    private void setIfPresentString(String key, JSONObject params) {
        this.setValue(key, JsonUtils.getOptionalString((JSONObject)params, (String)key));
    }
}

