/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.explore.ExploreContext;
import com.ibm.bi.predict.explore.ExploreParams;
import com.ibm.bi.predict.service.PredictContextFactory;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONObject;

public class ExploreContextFactory
implements PredictContextFactory {
    public static final String REQUESTID = "requestId";
    public static final String VERSION = "version";
    public static final String LOCALE = "locale";
    public static final String TARGET = "target";
    public static final String CANDIDATES = "candidates";
    public static final String GROUPINGS = "groupings";
    public static final String ID = "id";
    public static final String GROUPS = "groups";
    public static final String MEMBERS = "members";
    public static final String MAX_RELATIONSHIPS = "maxRelationships";
    public static final String MIN_STRENGTH = "minStrength";
    public static final String REQUESTED_ITEM_COUNT = "requestedItemCount";

    public ExploreContext make(JSONObject parameters) {
        ExploreContext context = new ExploreContext();
        context.loadDataContextProperties(parameters);
        context.mixin(parameters);
        return context;
    }

    public static List<ExploreParams.Grouping> getGroupings(JSONObject obj) {
        JSONArray array = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)GROUPINGS);
        int n = array.length();
        ArrayList<ExploreParams.Grouping> result = new ArrayList<ExploreParams.Grouping>();
        for (int i = 0; i < n; ++i) {
            JSONObject entry = JsonUtils.getRequiredJSONObject((JSONArray)array, (int)i, (String)GROUPINGS);
            String id = JsonUtils.getRequiredString((JSONObject)entry, (String)ID);
            List<ExploreParams.Group> groups = ExploreContextFactory.getGroups(entry);
            result.add(new ExploreParams.Grouping(id, groups));
        }
        return result;
    }

    public static List<ExploreParams.Group> getGroups(JSONObject obj) {
        JSONArray array = JsonUtils.getRequiredJSONArray((JSONObject)obj, (String)GROUPS);
        int n = array.length();
        ArrayList<ExploreParams.Group> result = new ArrayList<ExploreParams.Group>();
        for (int i = 0; i < n; ++i) {
            JSONObject entry = JsonUtils.getRequiredJSONObject((JSONArray)array, (int)i, (String)GROUPS);
            String id = JsonUtils.getRequiredString((JSONObject)entry, (String)ID);
            List members = JsonUtils.getStringArray((JSONObject)entry, (String)MEMBERS);
            result.add(new ExploreParams.Group(id, members));
        }
        return result;
    }
}

