/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;

public class ExploreParams {
    public static final String LOGGABLE_NAME_FOR_NULL = "'field name is null'";
    public static final String LOGGABLE_NAME_FOR_UNKNOWN = "'field name is unknown'";
    private final String version;
    private final String requestId;
    private final String localeStr;
    private final Locale locale;
    private final String target;
    private final List<String> candidates;
    private final List<Grouping> groupings;
    private final boolean sampledData;
    private final Optional<Integer> nnodes;

    public ExploreParams(String version, String requestId, String localeStr, String target, List<String> candidates, List<Grouping> groupings, boolean sampledData) {
        this(version, requestId, localeStr, target, candidates, groupings, sampledData, Optional.empty());
    }

    public ExploreParams(String version, String requestId, String localeStr, String target, List<String> candidates, List<Grouping> groupings, boolean sampledData, Optional<Integer> nnodes) {
        this.requestId = requestId != null ? requestId : UUID.randomUUID().toString();
        this.version = version;
        this.localeStr = localeStr;
        this.locale = localeStr != null ? new Locale(localeStr) : Locale.getDefault();
        this.target = target;
        this.candidates = candidates;
        this.groupings = groupings;
        this.sampledData = sampledData;
        this.nnodes = nnodes;
    }

    public String getVersion() {
        return this.version;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getCandidates() {
        return this.candidates;
    }

    public String getLocaleString() {
        return this.localeStr;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<Grouping> getGroupings() {
        return this.groupings;
    }

    public boolean isSampledData() {
        return this.sampledData;
    }

    public Optional<Integer> getNNodes() {
        return this.nnodes;
    }

    public int getFieldIndex(String name) {
        if (name.equals(this.target)) {
            return 0;
        }
        for (int i = 0; i < this.candidates.size(); ++i) {
            if (!name.equals(this.candidates.get(i))) continue;
            return i + 1;
        }
        return 1 + this.candidates.size();
    }

    public String getLoggableName(String name) {
        int i;
        if (name == null) {
            return LOGGABLE_NAME_FOR_NULL;
        }
        if (name.equals(this.target)) {
            return "'target'";
        }
        for (i = 0; i < this.candidates.size(); ++i) {
            if (!name.equals(this.candidates.get(i))) continue;
            return "'candidate " + i + "'";
        }
        for (i = 0; i < this.groupings.size(); ++i) {
            if (!name.equals(this.groupings.get(i).id)) continue;
            return "'grouping " + i + "'";
        }
        return LOGGABLE_NAME_FOR_UNKNOWN;
    }

    public String getLoggableName(int grouping, String name) {
        if (name == null) {
            return LOGGABLE_NAME_FOR_NULL;
        }
        if (grouping >= 0 && grouping < this.groupings.size()) {
            Grouping g = this.groupings.get(grouping);
            for (int i = 0; i < g.groups.size(); ++i) {
                if (!name.equals(((Group)g.groups.get(i)).id)) continue;
                return "'group " + i + " of grouping " + grouping + "'";
            }
        }
        return this.getLoggableName(name);
    }

    public static class Group {
        private final String id;
        private final List<String> members;

        public Group(String id, List<String> members) {
            this.id = id;
            this.members = members;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getMembers() {
            return this.members;
        }
    }

    public static class Grouping {
        private final String id;
        private final List<Group> groups;

        public Grouping(String id, List<Group> groups) {
            this.id = id;
            this.groups = groups;
        }

        public String getId() {
            return this.id;
        }

        public List<Group> getGroups() {
            return this.groups;
        }
    }
}

