/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.explore.ExploreContextFactory;
import com.ibm.bi.predict.explore.ExploreParams;
import com.ibm.bi.predict.utils.JsonUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.json.JSONObject;

public class ExploreParamsValidator {
    private ExploreParamsValidator() {
    }

    public static JSONObject validateParams(DataAccessProvider provider, JSONObject jparams) {
        if (jparams == null) {
            throw new BadParametersException("JSON parameters object is null");
        }
        if (provider == null) {
            throw new BadParametersException("DataAccessProvider is null");
        }
        if (jparams.isEmpty()) {
            throw new BadParametersException("Parameters object is null");
        }
        if (!jparams.containsKey((Object)"version")) {
            throw new BadParametersException("Required field 'version' missing or not string");
        }
        if (!jparams.containsKey((Object)"candidates")) {
            throw new BadParametersException("Required field 'candidates' missing or not string");
        }
        List<ExploreParams.Grouping> groupings = ExploreContextFactory.getGroupings(jparams);
        if (groupings.isEmpty()) {
            throw new BadParametersException("At least one grouping must be defined");
        }
        Set<String> fieldIds = ExploreParamsValidator.validateMetadata(provider);
        Set<String> inputIds = ExploreParamsValidator.validateTargetAndCandidates(jparams, fieldIds);
        if (inputIds.size() < 2) {
            throw new BadParametersException("Target plus candidates must give at least two input fields");
        }
        ExploreParamsValidator.validateGroupings(groupings, fieldIds, inputIds);
        return jparams;
    }

    private static Set<String> validateMetadata(DataAccessProvider provider) {
        MetaData md = provider.getMetaData();
        int fc = md.fieldCount();
        if (fc < 2) {
            throw new BadParametersException("Explore data must have at least two fields");
        }
        if (md.rowCount() < 1) {
            throw new BadParametersException("Explore data must have at least one row");
        }
        HashSet<String> fieldNames = new HashSet<String>();
        for (int i = 0; i < fc; ++i) {
            fieldNames.add(md.getFieldIdentifier(i));
        }
        return fieldNames;
    }

    private static Set<String> validateTargetAndCandidates(JSONObject jparams, Set<String> fieldIds) {
        HashSet<String> validIds = new HashSet<String>();
        String target = JsonUtils.getOptionalString((JSONObject)jparams, (String)"target");
        if (target != null) {
            if (!fieldIds.contains(target)) {
                throw new BadParametersException("Target ID '" + target + "' is not a data field");
            }
            validIds.add(target);
        }
        for (String id : JsonUtils.getStringArray((JSONObject)jparams, (String)"candidates")) {
            if (!fieldIds.contains(id)) {
                throw new BadParametersException("Candidates ID '" + id + "' is not a data field");
            }
            validIds.add(id);
        }
        return validIds;
    }

    private static void validateGroupings(List<ExploreParams.Grouping> groupings, Set<String> fieldIds, Set<String> inputIds) {
        HashSet<String> groupingIds = new HashSet<String>();
        for (ExploreParams.Grouping grouping : groupings) {
            String groupingId = grouping.getId();
            if (groupingIds.contains(groupingId)) {
                throw new BadParametersException("Duplicate grouping ID '" + groupingId + "'");
            }
            groupingIds.add(groupingId);
            ExploreParamsValidator.validateGroups(grouping, fieldIds, inputIds);
        }
    }

    private static void validateGroups(ExploreParams.Grouping grouping, Set<String> fieldIds, Set<String> inputIds) {
        HashSet<String> groupIds = new HashSet<String>();
        for (ExploreParams.Group group : grouping.getGroups()) {
            String groupId = group.getId();
            if (groupIds.contains(groupId)) {
                throw new BadParametersException("Duplicate group ID '" + groupId + "' (grouping " + grouping.getId() + ")");
            }
            if (fieldIds.contains(groupId)) {
                throw new BadParametersException("Group ID '" + groupId + "' is the same as a field ID (grouping " + grouping.getId() + ")");
            }
            groupIds.add(groupId);
            ExploreParamsValidator.validateMembers(grouping, group, inputIds);
        }
    }

    private static void validateMembers(ExploreParams.Grouping grouping, ExploreParams.Group group, Set<String> inputIds) {
        for (String mid : group.getMembers()) {
            if (inputIds.contains(mid)) continue;
            throw new BadParametersException("Member ID '" + mid + "' is not a valid field (grouping " + grouping.getId() + ", group " + group.getId() + ")");
        }
    }
}

