/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore;

import com.ibm.bi.predict.data.DataPrep;
import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.explore.ExploreContext;
import com.ibm.bi.predict.explore.ExploreDataPrep;
import com.ibm.bi.predict.explore.ExploreParamsValidator;
import com.ibm.bi.predict.explore.relationship.RelationshipStrengthsAlgorithm;
import com.ibm.bi.predict.explore.relationship.RelationshipStrengthsResult;
import com.ibm.bi.predict.explore.result.ExploreResult;
import com.ibm.bi.predict.result.DataPrepResult;
import com.ibm.bi.predict.result.ExecutionResult;
import com.ibm.bi.predict.service.PredictServiceFramework;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import org.apache.commons.json.JSONObject;

public class ExploreService
implements PredictServiceFramework {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ExploreService.class);
    private final ExploreContext context;

    private ExploreService(ExploreContext context) {
        this.context = context;
    }

    public static ExploreService getService() {
        return ExploreService.getService(new ExploreContext());
    }

    public static ExploreService getService(ExploreContext context) {
        return new ExploreService(context);
    }

    public ExploreResult runAlgorithms(DataAccessProvider provider, JSONObject jparams) {
        LOGGER.debug("PEXALG - received request, parsing parameters");
        try {
            ExploreParamsValidator.validateParams(provider, jparams);
            this.context.mixin(jparams);
        }
        catch (Exception e) {
            LOGGER.error("PEXALG - exception while parsing and validating JSON parameters", (Throwable)e);
            throw e;
        }
        return this.runAlgorithms(provider, this.context);
    }

    public ExploreResult runAlgorithms(DataAccessProvider provider, ExploreContext context) {
        RelationshipStrengthsResult relationshipStrengthsResult;
        DataPrepResult dataPrepResult;
        LOGGER.perfStart();
        String requestId = context.getExploreRequestId();
        LOGGER.debug("PEXALG - {} - beginning processing", (Object)requestId);
        LOGGER.perfLog("PEXALG - {} - prepare data     ", (Object)requestId);
        try {
            dataPrepResult = ExploreDataPrep.prepareData(provider, context).buildResult();
        }
        catch (Exception e) {
            LOGGER.error(String.format("PEXALG - %s - exception while preparing data", requestId), (Throwable)e);
            LOGGER.perfStop();
            throw e;
        }
        LOGGER.perfLog("PEXALG - {} - run strengths    ", (Object)requestId);
        try {
            RelationshipStrengthsAlgorithm alg = new RelationshipStrengthsAlgorithm(context);
            relationshipStrengthsResult = alg.prepareResults((DataPrep)dataPrepResult.getContent());
        }
        catch (Exception e) {
            LOGGER.error(String.format("PEXALG - %s - exception while calculating relationship strength result.", requestId), (Throwable)e);
            LOGGER.perfStop();
            throw e;
        }
        LOGGER.perfLog("PEXALG - {} - merging results    ", (Object)requestId);
        ExploreResult result = ExploreService.mergeResults(dataPrepResult, relationshipStrengthsResult);
        LOGGER.perfLog("PEXALG - {} - done             ", (Object)requestId);
        LOGGER.perfStop();
        LOGGER.debug("PEXALG - {} - finished", (Object)requestId);
        return result;
    }

    private static ExploreResult mergeResults(DataPrepResult dataResult, RelationshipStrengthsResult relationshipStrengthsResult) {
        ExploreResult result = new ExploreResult(relationshipStrengthsResult.getStatus(), (List)relationshipStrengthsResult.getContent(), relationshipStrengthsResult.getContext());
        result.addMessages((ExecutionResult)dataResult);
        result.addMessages(relationshipStrengthsResult);
        return result;
    }
}

