/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.data;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.exceptions.InvalidDataException;
import com.ibm.bi.predict.explore.data.RecordingDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;

public class DataAccessProviderBuilder {
    private Optional<Integer> dataLength = Optional.empty();
    private final List<FieldBuilder> fields = new ArrayList<FieldBuilder>();
    private final Map<String, FieldBuilder> fieldMap = new HashMap<String, FieldBuilder>();

    public FieldBuilder addField(String fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("Field ID must not be null");
        }
        if (this.fieldMap.containsKey(fieldId)) {
            throw new IllegalArgumentException("Field ID '" + fieldId + "' already defined");
        }
        FieldBuilder builder = new FieldBuilder(fieldId);
        this.fields.add(builder);
        this.fieldMap.put(fieldId, builder);
        return builder;
    }

    public FieldBuilder getField(String fieldId) {
        if (fieldId == null) {
            throw new IllegalArgumentException("Field ID must not be null");
        }
        if (!this.fieldMap.containsKey(fieldId)) {
            throw new IllegalArgumentException("Field ID '" + fieldId + "' is not defined");
        }
        return this.fieldMap.get(fieldId);
    }

    public FieldBuilder getField(int index) {
        if (index < 0 || index >= this.fields.size()) {
            throw new IllegalArgumentException("Illegal field index " + index);
        }
        return this.fields.get(index);
    }

    public DataAccessProvider makeProvider() {
        int rowCount = this.dataLength.isPresent() ? this.dataLength.get() : 0;
        for (FieldBuilder f : this.fields) {
            if (f.data.length == rowCount) continue;
            throw new InvalidDataException("Field '" + f.fieldId + "' does not have data");
        }
        return new DataAccessProviderImpl();
    }

    private void checkDataLength(int len) {
        if (this.dataLength.isPresent()) {
            if (this.dataLength.get() != len) {
                throw new IllegalArgumentException("Data length does not match previous data");
            }
        } else {
            this.dataLength = Optional.of(len);
        }
    }

    public class DataIteratorImpl
    implements DataIterator {
        int row = 0;

        public boolean hasNext() {
            return this.row < (DataAccessProviderBuilder.this.dataLength.isPresent() ? (Integer)DataAccessProviderBuilder.this.dataLength.get() : 0);
        }

        public DataRow next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("DataIterator next() called");
            }
            final int currRow = this.row++;
            return new DataRow(){

                public double getStatistic(String statName, int col) {
                    FieldBuilder field = (FieldBuilder)DataAccessProviderBuilder.this.fields.get(col);
                    return field.statistics.containsKey(statName) ? field.statistics.get(statName)[currRow] : 0.0;
                }

                public double getValue(int col) {
                    return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).data[currRow];
                }
            };
        }

        public void reset() {
            this.row = 0;
        }
    }

    public class DataAccessProviderImpl
    implements DataAccessProvider {
        private final MetaData meta;
        private final Decorator deco;

        public DataAccessProviderImpl() {
            this.meta = new MetaDataImpl();
            this.deco = new RecordingDecorator();
        }

        public DataIterator getDataIterator() {
            return new DataIteratorImpl();
        }

        public Decorator getDecorator() {
            return this.deco;
        }

        public MetaData getMetaData() {
            return this.meta;
        }
    }

    public class MetaDataImpl
    implements MetaData {
        public int fieldCount() {
            return DataAccessProviderBuilder.this.fields.size();
        }

        public String getFieldIdentifier(int col) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).fieldId;
        }

        public List<String> getFieldIdentifiers(int col) {
            return Arrays.asList(this.getFieldIdentifier(col));
        }

        public String getFieldDisplayLabel(int col) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).label;
        }

        public FieldType getFieldType(int col) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).type;
        }

        public AggregationType getFieldAggregation(int col) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).aggregation;
        }

        public int getFieldCategories(int col) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).categories.length;
        }

        public String getFieldCategoryLabel(int col, int cat) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).categories[cat];
        }

        public StatisticStatus getStatisticStatus(String statName, int col) {
            return ((FieldBuilder)((DataAccessProviderBuilder)DataAccessProviderBuilder.this).fields.get((int)col)).statistics.containsKey(statName) ? StatisticStatus.AVAILABLE : StatisticStatus.UNAVAILABLE;
        }

        public int rowCount() {
            return DataAccessProviderBuilder.this.dataLength.isPresent() ? (Integer)DataAccessProviderBuilder.this.dataLength.get() : 0;
        }
    }

    public class FieldBuilder {
        final String fieldId;
        String label;
        FieldType type;
        AggregationType aggregation;
        String[] categories;
        double[] data;
        final Map<String, double[]> statistics;

        FieldBuilder(String fieldId) {
            this.fieldId = fieldId;
            this.label = fieldId;
            this.type = FieldType.NUMERICAL;
            this.aggregation = AggregationType.NONE;
            this.categories = new String[0];
            this.data = new double[0];
            this.statistics = new HashMap<String, double[]>();
        }

        public FieldBuilder label(String label) {
            if (label != null) {
                this.label = label;
            }
            return this;
        }

        public FieldBuilder type(FieldType type) {
            if (type != null) {
                this.type = type;
            }
            return this;
        }

        public FieldBuilder aggregation(AggregationType aggregation) {
            if (aggregation != null) {
                this.aggregation = aggregation;
            }
            return this;
        }

        public FieldBuilder categories(int n) {
            int ncats = n < 0 ? 0 : n;
            this.categories = new String[ncats];
            for (int i = 0; i < ncats; ++i) {
                this.categories[i] = this.label + "_CAT" + i;
            }
            return this;
        }

        public FieldBuilder categories(String[] categories) {
            if (categories != null) {
                this.categories = categories;
            }
            return this;
        }

        public FieldBuilder data(double[] data) {
            if (data != null) {
                DataAccessProviderBuilder.this.checkDataLength(data.length);
                this.data = data;
            }
            return this;
        }

        public FieldBuilder statistic(String statisticName, double[] data) {
            if (statisticName != null && data != null) {
                DataAccessProviderBuilder.this.checkDataLength(data.length);
                this.statistics.put(statisticName, data);
            }
            return this;
        }
    }
}

