/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.data;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.Decorator;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class RecordingDecorator
implements Decorator {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(RecordingDecorator.class);
    private static final String EXCEPTION_MSG = "TestDecorator exception in base decorator: ";
    private final Decorator base;
    private final List<Deco> calls;

    public RecordingDecorator() {
        this(null);
    }

    public RecordingDecorator(Decorator base) {
        this.base = base;
        this.calls = new ArrayList<Deco>();
    }

    public List<Deco> getCalls() {
        return this.calls;
    }

    public void clearCalls() {
        this.calls.clear();
    }

    public void decorateCell(int columnIdx, int rowIdx, String key, Boolean value) {
        if (this.base != null) {
            try {
                this.base.decorateCell(columnIdx, rowIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, rowIdx, key, value));
    }

    public void decorateCell(int columnIdx, int rowIdx, String key, String value) {
        if (this.base != null) {
            try {
                this.base.decorateCell(columnIdx, rowIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, rowIdx, key, value));
    }

    public void decorateCell(int columnIdx, int rowIdx, String key, String[] value) {
        if (this.base != null) {
            try {
                this.base.decorateCell(columnIdx, rowIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, rowIdx, key, value));
    }

    public void decorateCell(int columnIdx, int rowIdx, String key, String[][] value) {
        if (this.base != null) {
            try {
                this.base.decorateCell(columnIdx, rowIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, rowIdx, key, value));
    }

    public void decorateCell(int columnIdx, int rowIdx, String key, Number value) {
        if (this.base != null) {
            try {
                this.base.decorateCell(columnIdx, rowIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, rowIdx, key, value));
    }

    public void decorateCell(int columnIdx, int rowIdx, String key, Number[] value) {
        if (this.base != null) {
            try {
                this.base.decorateCell(columnIdx, rowIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, rowIdx, key, value));
    }

    public void decorateColumn(int columnIdx, String key, Boolean value) {
        if (this.base != null) {
            try {
                this.base.decorateColumn(columnIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, key, value));
    }

    public void decorateColumn(int columnIdx, String key, String value) {
        if (this.base != null) {
            try {
                this.base.decorateColumn(columnIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, key, value));
    }

    public void decorateColumn(int columnIdx, String key, String[] value) {
        if (this.base != null) {
            try {
                this.base.decorateColumn(columnIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, key, (Object)value));
    }

    public void decorateColumn(int columnIdx, String key, Number value) {
        if (this.base != null) {
            try {
                this.base.decorateColumn(columnIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, key, value));
    }

    public void decorateColumn(int columnIdx, String key, Number[] value) {
        if (this.base != null) {
            try {
                this.base.decorateColumn(columnIdx, key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(columnIdx, key, value));
    }

    public void decorateGlobal(String key, Boolean value) {
        if (this.base != null) {
            try {
                this.base.decorateGlobal(key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(key, value));
    }

    public void decorateGlobal(String key, String value) {
        if (this.base != null) {
            try {
                this.base.decorateGlobal(key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(key, value));
    }

    public void decorateGlobal(String key, String[] value) {
        if (this.base != null) {
            try {
                this.base.decorateGlobal(key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(key, value));
    }

    public void decorateGlobal(String key, Number value) {
        if (this.base != null) {
            try {
                this.base.decorateGlobal(key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(key, value));
    }

    public void decorateGlobal(String key, Number[] value) {
        if (this.base != null) {
            try {
                this.base.decorateGlobal(key, value);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(key, value));
    }

    public int addDataRow(Number[] data) {
        int index = -1;
        if (this.base != null) {
            try {
                index = this.base.addDataRow(data);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(data));
        return index;
    }

    public void addCategory(int columnIndex, String[] displayLabels, String[] uniqueIds) {
        if (this.base != null) {
            try {
                this.base.addCategory(columnIndex, displayLabels, uniqueIds);
            }
            catch (Exception e) {
                LOGGER.debug(EXCEPTION_MSG + e.getMessage(), (Throwable)e);
            }
        }
        this.calls.add(new Deco(displayLabels, columnIndex, uniqueIds));
    }

    public static DataAccessProvider makeProvider(DataAccessProvider provider) {
        RecordingDecorator deco = new RecordingDecorator();
        return RecordingDecorator.makeProvider(provider, deco);
    }

    public static DataAccessProvider makeProviderWithBaseDecorator(DataAccessProvider provider) {
        Decorator baseDeco = null;
        try {
            baseDeco = provider.getDecorator();
        }
        catch (Exception e) {
            LOGGER.debug("Exception making a provider with base decorator " + e.getMessage());
        }
        RecordingDecorator deco = new RecordingDecorator(baseDeco);
        return RecordingDecorator.makeProvider(provider, deco);
    }

    private static DataAccessProvider makeProvider(final DataAccessProvider provider, final RecordingDecorator deco) {
        return new DataAccessProvider(){

            public DataIterator getDataIterator() {
                return provider.getDataIterator();
            }

            public Decorator getDecorator() {
                return deco;
            }

            public MetaData getMetaData() {
                return provider.getMetaData();
            }
        };
    }

    public static class Deco {
        public final DecoType type;
        public final int columnIdx;
        public final int rowIdx;
        public final String key;
        public final Object value;
        public final Number[] data;
        public final String[] displayLabels;
        public final String[] uniqueIds;

        Deco(int columnIdx, int rowIdx, String key, Object value) {
            this.type = DecoType.CELL;
            this.columnIdx = columnIdx;
            this.rowIdx = rowIdx;
            this.key = key;
            this.value = value;
            this.data = null;
            this.displayLabels = null;
            this.uniqueIds = null;
        }

        Deco(int columnIdx, String key, Object value) {
            this.type = DecoType.COLUMN;
            this.columnIdx = columnIdx;
            this.rowIdx = -1;
            this.key = key;
            this.value = value;
            this.data = null;
            this.displayLabels = null;
            this.uniqueIds = null;
        }

        Deco(String key, Object value) {
            this.type = DecoType.GLOBAL;
            this.columnIdx = -1;
            this.rowIdx = -1;
            this.key = key;
            this.value = value;
            this.data = null;
            this.displayLabels = null;
            this.uniqueIds = null;
        }

        Deco(Number[] data) {
            this.type = DecoType.DATA;
            this.columnIdx = -1;
            this.rowIdx = -1;
            this.key = null;
            this.value = null;
            this.data = data;
            this.displayLabels = null;
            this.uniqueIds = null;
        }

        Deco(String[] displayLabels, int columnIndex, String[] uniqueIds) {
            this.type = DecoType.CATEGORY;
            this.columnIdx = columnIndex;
            this.rowIdx = -1;
            this.key = null;
            this.value = null;
            this.data = null;
            this.displayLabels = displayLabels;
            this.uniqueIds = uniqueIds;
        }

        public String toString() {
            if (this.type == DecoType.CELL) {
                return "Cell [" + this.columnIdx + "," + this.rowIdx + "]: " + this.key + " -> " + Deco.valueToString(this.value);
            }
            if (this.type == DecoType.COLUMN) {
                return "Column [" + this.columnIdx + "]: " + this.key + " -> " + Deco.valueToString(this.value);
            }
            if (this.type == DecoType.GLOBAL) {
                return "Global: " + this.key + " -> " + Deco.valueToString(this.value);
            }
            if (this.type == DecoType.DATA) {
                return "Data: " + Deco.valueToString(this.data);
            }
            return "Category [" + this.columnIdx + "]: [" + Deco.displayLabelsUniqueIdsToString(this.displayLabels, this.uniqueIds) + "]";
        }

        private static String displayLabelsUniqueIdsToString(String[] displayLabels, String[] uniqueIds) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < uniqueIds.length; ++i) {
                sb.append("{u: " + uniqueIds[i] + ", d: " + displayLabels[i] + "}");
                if (i >= uniqueIds.length - 1) continue;
                sb.append(",");
            }
            return sb.toString();
        }

        private static String valueToString(Object v) {
            if (v == null) {
                return "null";
            }
            if (v instanceof String[]) {
                return Arrays.toString((String[])v);
            }
            if (v instanceof Number[]) {
                return Arrays.toString((Number[])v);
            }
            return v.toString();
        }
    }

    public static enum DecoType {
        CELL,
        COLUMN,
        GLOBAL,
        DATA,
        CATEGORY;

    }
}

