/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt;

import com.ibm.bi.predict.explore.Tag;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.framework.RequestProvider;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ChartInsight
implements RequestProvider {
    public static final String LABEL_KEY = "label";
    public static final String ACTION_KEY = "action";
    public static final String TAGS_KEY = "tags";
    private final Request params;
    private final String label;
    private final JSONObject action;
    private final Set<Tag> tags;
    private final String type;
    private final InsightSemantics semantics;

    public ChartInsight(Request params, String label, JSONObject action, Set<Tag> tags, String type, InsightSemantics semantics) {
        this.params = params;
        this.label = label;
        this.action = action;
        this.tags = tags;
        this.type = type;
        this.semantics = semantics;
    }

    @Override
    public Request getRequest() {
        return this.params;
    }

    public InsightSemantics semantics() {
        return this.semantics;
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject obj = new JSONObject();
        obj.put(LABEL_KEY, (Object)this.label);
        obj.put(ACTION_KEY, (Map)this.action);
        obj.put(TAGS_KEY, (Collection)new JSONArray((Collection)this.tags.stream().map(Tag::toString).collect(Collectors.toList())));
        return obj;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<Tag> getTags() {
        return this.tags;
    }

    public String toString() {
        return this.label;
    }

    public Request getParams() {
        return this.params;
    }

    public String getType() {
        return this.type;
    }
}

