/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.deriveddata.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.dataaccess.types.StatisticStatus;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.deriveddata.detectors.DerivedDataDetector;
import com.ibm.bi.predict.explore.nlt.deriveddata.operations.AggregateToOneInputOperation;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.types.RoleType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class AggregateToOneInputDetector
extends DerivedDataDetector {
    @Override
    public List<Operation<Request>> detectOperation(Request request) {
        ChartInsightsContext params;
        if (!request.has(DataAccessProvider.class)) {
            return Collections.emptyList();
        }
        MetaData metadata = request.get(DataAccessProvider.class).getMetaData();
        List<Integer> respFields = this.getResponseFields(metadata, params = request.get(ChartInsightsContext.class));
        if (respFields.isEmpty()) {
            return Collections.emptyList();
        }
        List<Integer> inputFields = this.getInputFields(metadata, params);
        if (inputFields.size() < 2) {
            return Collections.emptyList();
        }
        Optional<Integer> weightIndex = this.getWeightField(metadata, params);
        return respFields.stream().map(responseIndex -> inputFields.stream().map(input -> this.makeReaggregator(request, metadata, (int)responseIndex, weightIndex, (int)input)).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public boolean isSuitableResponse(MetaData metadata, ChartInsightsContext params, int idx) {
        return params.getRole(metadata.getFieldIdentifier(idx)) == RoleType.RESPONSE && metadata.getFieldType(idx) == FieldType.NUMERICAL && metadata.getFieldAggregation(idx) != AggregationType.COUNT_DISTINCT && metadata.getStatisticStatus("rowCount", idx) == StatisticStatus.AVAILABLE;
    }

    private AggregateToOneInputOperation makeReaggregator(Request request, MetaData meta, int response, Optional<Integer> weightIndex, int explanatory) {
        switch (meta.getFieldAggregation(response)) {
            case AVERAGE: {
                return AggregateToOneInputOperation.average(request, response, explanatory, weightIndex);
            }
            case MINIMUM: {
                return AggregateToOneInputOperation.min(request, response, explanatory, weightIndex, Double.POSITIVE_INFINITY);
            }
            case MAXIMUM: {
                return AggregateToOneInputOperation.max(request, response, explanatory, weightIndex, Double.NEGATIVE_INFINITY);
            }
        }
        return AggregateToOneInputOperation.sum(request, response, explanatory, weightIndex);
    }
}

