/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.deriveddata.detectors;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.exceptions.InvalidDataException;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.framework.Detector;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.types.RoleType;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class DerivedDataDetector
implements Detector<Request> {
    protected boolean isSuitableInput(MetaData metadata, ChartInsightsContext params, int idx) {
        RoleType role = params.getRole(metadata.getFieldIdentifier(idx));
        return !(metadata.getFieldType(idx) != FieldType.CATEGORICAL && metadata.getFieldType(idx) != FieldType.DATETIME || role != RoleType.EXPLANATORY && role != RoleType.GROUP && role != RoleType.REPEAT);
    }

    public abstract boolean isSuitableResponse(MetaData var1, ChartInsightsContext var2, int var3);

    protected boolean isSuitableWeight(MetaData metadata, ChartInsightsContext params, int idx) {
        RoleType role = params.getRole(metadata.getFieldIdentifier(idx));
        return role == RoleType.WEIGHT && metadata.getFieldType(idx) == FieldType.NUMERICAL;
    }

    Optional<Integer> getWeightField(MetaData metaData, ChartInsightsContext params) {
        List weight = IntStream.range(0, metaData.fieldCount()).filter(idx -> this.isSuitableWeight(metaData, params, idx)).mapToObj(idx -> idx).collect(Collectors.toList());
        if (weight.size() > 1) {
            throw new InvalidDataException("More than one weight are specified. Only one is allowed.");
        }
        return weight.stream().findFirst();
    }

    List<Integer> getInputFields(MetaData metaData, ChartInsightsContext params) {
        return IntStream.range(0, metaData.fieldCount()).filter(idx -> this.isSuitableInput(metaData, params, idx)).mapToObj(idx -> idx).collect(Collectors.toList());
    }

    List<Integer> getResponseFields(MetaData metaData, ChartInsightsContext params) {
        return IntStream.range(0, metaData.fieldCount()).filter(idx -> this.isSuitableResponse(metaData, params, idx)).mapToObj(idx -> idx).collect(Collectors.toList());
    }
}

