/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.deriveddata.operations;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.types.RoleType;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;

public abstract class DerivedDataOperation
extends Operation<Request> {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(DerivedDataOperation.class);

    protected DerivedDataOperation(Request request) {
        super(request);
    }

    protected String[] getCategoryLabels(MetaData metadata, int columnIndex) {
        int nc = metadata.getFieldCategories(columnIndex);
        String[] result = new String[nc];
        try {
            for (int i = 0; i < nc; ++i) {
                result[i] = metadata.getFieldCategoryLabel(columnIndex, i);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Exception on MetaData.getFieldCategoryLabel, generating labels for this category", (Throwable)e);
            String fieldId = metadata.getFieldIdentifier(columnIndex);
            for (int i = 0; i < nc; ++i) {
                result[i] = fieldId + "_CAT" + i;
            }
        }
        return result;
    }

    protected RoleType getInputRole(MetaData metadata, ChartInsightsContext params, int fieldIndex) {
        RoleType inputRole = params.getRole(metadata.getFieldIdentifier(fieldIndex));
        if (inputRole == RoleType.GROUP || inputRole == RoleType.REPEAT) {
            inputRole = RoleType.EXPLANATORY;
        }
        return inputRole;
    }
}

