/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.framework;

import com.ibm.bi.predict.explore.nlt.framework.Detector;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.ProcessorResults;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public final class Analyzer<T> {
    private final List<Detector<T>> detectorList;
    private static final com.ibm.bi.predict.utils.Logger LOGGER = PredictLoggerFactory.getLogger(Analyzer.class);

    public Analyzer(List<Detector<T>> detectorList) {
        this.detectorList = detectorList;
    }

    public ProcessorResults<Operation<T>> process(Request request) {
        ProcessorResults<Operation<T>> results = new ProcessorResults<Operation<T>>();
        this.detectorList.forEach(op -> this.applyOperation(request, (Detector<T>)op, results));
        return results;
    }

    private void applyOperation(Request request, Detector<T> op, ProcessorResults<Operation<T>> results) {
        try {
            List<Operation<T>> operations = op.detectOperation(request);
            if (operations == null) {
                results.addWarning("Detector returned a null list instead of empty list: " + op, (Logger)LOGGER);
            } else {
                results.addAll(operations);
            }
        }
        catch (Exception e) {
            results.addError("Exception during detect operations for " + op, e, (Logger)LOGGER);
        }
    }
}

