/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.framework;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.DataIterator;
import com.ibm.bi.predict.dataaccess.DataRow;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.ProcessorResults;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;

public class Dispatcher<T> {
    private static final com.ibm.bi.predict.utils.Logger LOGGER = PredictLoggerFactory.getLogger(Dispatcher.class);

    public void process(Request request, List<Operation<T>> operations, ProcessorResults<T> results) {
        if (operations.isEmpty()) {
            return;
        }
        LOGGER.perfStart();
        LOGGER.perfLog("Start processing operations of request " + request.toString());
        operations.removeIf(op -> this.preUpdate((Operation<T>)op, results));
        LOGGER.perfLog("PreUpdate operations completed");
        Optional<DataIterator> rowIterator = request.getOpt(DataIterator.class);
        if (!rowIterator.isPresent()) {
            rowIterator = request.getOpt(DataAccessProvider.class).map(DataAccessProvider::getDataIterator);
        }
        rowIterator.ifPresent(it -> this.applyOperationsToRows((List<Operation<T>>)operations, (DataIterator)it, results));
        LOGGER.perfLog("Update operations completed");
        operations.forEach(op -> this.postUpdateAndStoreResults((Operation<T>)op, results));
        LOGGER.perfLog("PostUpdate operations completed");
        LOGGER.perfStop();
    }

    private void postUpdateAndStoreResults(Operation<T> op, ProcessorResults<T> results) {
        try {
            op.postUpdate();
        }
        catch (Exception e) {
            results.addError("Error in postUpdate for: " + op, e, (Logger)LOGGER);
            return;
        }
        try {
            results.addAll(op.getResults());
        }
        catch (Exception e) {
            results.addError("Error in getResults for: " + op, e, (Logger)LOGGER);
        }
    }

    private boolean preUpdate(Operation<T> op, ProcessorResults<T> results) {
        try {
            op.preUpdate();
            return false;
        }
        catch (Exception e) {
            results.addError("Error in preUpdate for: " + op, e, (Logger)LOGGER);
            return true;
        }
    }

    private void applyOperationsToRows(List<Operation<T>> operations, DataIterator it, ProcessorResults<T> results) {
        while (it.hasNext()) {
            DataRow row = (DataRow)it.next();
            operations.removeIf(op -> this.updateOpWithRow((Operation<T>)op, row, results));
        }
    }

    private boolean updateOpWithRow(Operation<T> op, DataRow row, ProcessorResults<T> results) {
        try {
            op.update(row);
            return false;
        }
        catch (Exception e) {
            results.addError("Error in update for: " + op + " on row " + row, e, (Logger)LOGGER);
            return true;
        }
    }
}

