/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.framework;

import com.ibm.bi.predict.explore.nlt.framework.Filter;
import com.ibm.bi.predict.explore.nlt.framework.ProcessorResults;
import com.ibm.bi.predict.explore.nlt.framework.RequestProvider;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import org.slf4j.Logger;

public final class Filtering<T extends RequestProvider> {
    private static final com.ibm.bi.predict.utils.Logger LOGGER = PredictLoggerFactory.getLogger(Filtering.class);
    private final List<Filter<T>> filterFunctions;

    public Filtering(List<Filter<T>> filterFunctions) {
        this.filterFunctions = filterFunctions;
        if (filterFunctions == null) {
            throw new IllegalArgumentException("List may be empty, but cannot be null");
        }
    }

    public void process(ProcessorResults<T> input) {
        this.filterFunctions.forEach(filter -> this.filterContent((Filter<T>)filter, input));
    }

    private void filterContent(Filter<T> filter, ProcessorResults<T> items) {
        try {
            List<T> list = filter.filter(items.content());
            items.replaceContent(list);
        }
        catch (Exception e) {
            items.addError("Error applying filter: " + filter, e, (Logger)LOGGER);
        }
    }
}

