/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.framework;

import com.ibm.bi.predict.data.Context;
import com.ibm.bi.predict.explore.nlt.framework.Analyzer;
import com.ibm.bi.predict.explore.nlt.framework.Detector;
import com.ibm.bi.predict.explore.nlt.framework.Dispatcher;
import com.ibm.bi.predict.explore.nlt.framework.Filter;
import com.ibm.bi.predict.explore.nlt.framework.Filtering;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.ProcessorResults;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.framework.RequestProvider;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class Processor<T extends RequestProvider> {
    private final Analyzer<T> analyzer;
    private final Filtering<Operation<T>> operationFilter;
    private final Dispatcher<T> dispatcher;
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(Processor.class);

    public Processor(Context context) {
        this.analyzer = new Analyzer<T>(this.getDetectors(context));
        this.operationFilter = new Filtering(this.getFilters());
        this.dispatcher = new Dispatcher();
    }

    public ProcessorResults<T> process(Request request) {
        return this.process(Collections.singleton(request));
    }

    public ProcessorResults<T> process(Collection<Request> requests) {
        LOGGER.perfStart();
        LOGGER.perfLog("Start process of " + this.purpose());
        ProcessorResults operations = requests.stream().map(this.analyzer::process).reduce(ProcessorResults::merge).orElseGet(() -> new ProcessorResults());
        LOGGER.perfLog("Created operations");
        this.operationFilter.process(operations);
        LOGGER.perfLog("Filtered operations");
        Map<Request, List<Operation>> map = operations.content().stream().collect(Collectors.groupingBy(Operation::getRequest));
        ProcessorResults results = new ProcessorResults();
        map.forEach((request, op) -> this.dispatcher.process((Request)request, (List<Operation<T>>)op, results));
        LOGGER.perfLog("Completed process of " + this.purpose());
        LOGGER.perfStop();
        return results;
    }

    public abstract List<Detector<T>> getDetectors(Context var1);

    protected List<Filter<Operation<T>>> getFilters() {
        return Collections.emptyList();
    }

    protected abstract String purpose();
}

