/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights;

import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Filter;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.framework.RequestProvider;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class InsightsOperationsFilter
implements Filter<Operation<ChartInsight>> {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(InsightsOperationsFilter.class);

    protected static <T extends RequestProvider> Request getUniqueOriginal(Collection<T> items) {
        List roots = items.stream().map(RequestProvider::getRequest).map(Request::original).distinct().collect(Collectors.toList());
        if (roots.size() != 1) {
            LOGGER.error("Attempt to filter items from different original requests");
            throw new IllegalArgumentException("Cannot compare insights from different original requests");
        }
        return (Request)roots.get(0);
    }

    @Override
    public List<Operation<ChartInsight>> filter(List<Operation<ChartInsight>> input) {
        if (input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Operation<ChartInsight>> notInsightOps = new ArrayList<Operation<ChartInsight>>();
        LinkedList<InsightsOperation> insightOps = InsightsOperationsFilter.collectItemsToEvaluate(input, notInsightOps);
        Collection filtered = this.filterInsights(insightOps).stream().map(x -> x).collect(Collectors.toList());
        ArrayList<Operation<ChartInsight>> results = new ArrayList<Operation<ChartInsight>>(input);
        results.retainAll(filtered);
        filtered.removeAll(results);
        results.addAll(filtered);
        return results;
    }

    protected abstract Collection<InsightsOperation> filterInsights(LinkedList<InsightsOperation> var1);

    private static LinkedList<InsightsOperation> collectItemsToEvaluate(List<Operation<ChartInsight>> input, List<Operation<ChartInsight>> cannotEvaluate) {
        LinkedList<InsightsOperation> toProcess = new LinkedList<InsightsOperation>();
        for (Operation<ChartInsight> op : input) {
            if (op instanceof InsightsOperation) {
                toProcess.add((InsightsOperation)op);
                continue;
            }
            LOGGER.warn("Cannot filter an operation that was not an InsightsOperation: " + op);
            cannotEvaluate.add(op);
        }
        return toProcess;
    }
}

