/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights;

import com.ibm.bi.predict.dataaccess.types.AggregationType;

public class OperationType {
    public static final OperationType AGGREGATION_SUM = new OperationType(Base.aggregation, AggregationType.SUM);
    public static final OperationType AGGREGATION_AVERAGE = new OperationType(Base.aggregation, AggregationType.AVERAGE);
    public static final OperationType AGGREGATION_COUNT = new OperationType(Base.aggregation, AggregationType.COUNT);
    public static final OperationType UNIQUE = new OperationType(Base.unique, null);
    private final Base base;
    private final AggregationType aggregation;

    public OperationType(Base base, AggregationType aggregation) {
        this.base = base;
        this.aggregation = aggregation;
        if (base == null) {
            throw new IllegalArgumentException("Base must not be null");
        }
    }

    public Base base() {
        return this.base;
    }

    public AggregationType aggregation() {
        return this.aggregation;
    }

    public boolean isAggregation() {
        return this.base == Base.aggregation;
    }

    public boolean isUnique() {
        return this.base == Base.unique;
    }

    public boolean comparableBases(OperationType other) {
        return this.base == other.base && this.base != Base.unique;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationType that = (OperationType)o;
        return this.base == that.base && this.aggregation == that.aggregation;
    }

    public int hashCode() {
        return 31 * this.base.hashCode() + (this.aggregation != null ? this.aggregation.hashCode() : 0);
    }

    public String toString() {
        return (Object)((Object)this.base) + (this.aggregation == null ? "" : "-" + this.aggregation);
    }

    public static enum Base {
        aggregation,
        range,
        unique;

    }
}

