/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights;

import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.explore.nlt.insights.InsightSemantics;
import com.ibm.bi.predict.explore.nlt.insights.InsightsOperationsFilter;
import com.ibm.bi.predict.explore.nlt.insights.operations.InsightsOperation;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class RedundantInsightOperationsFilter
extends InsightsOperationsFilter {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(RedundantInsightOperationsFilter.class);

    @Override
    protected Collection<InsightsOperation> filterInsights(LinkedList<InsightsOperation> inputs) {
        ArrayList<InsightsOperation> validated = new ArrayList<InsightsOperation>();
        Request original = InsightsOperationsFilter.getUniqueOriginal(inputs);
        BiPredicate<InsightSemantics, InsightSemantics> subsumeFunc = InsightSemantics.subsumeFunctionGivenRequest(original);
        while (!inputs.isEmpty()) {
            InsightsOperation trial = inputs.removeFirst();
            Optional<InsightsOperation> better = Stream.concat(validated.stream(), inputs.stream()).filter((? super T op) -> subsumeFunc.test(op.semantics(), trial.semantics())).findAny();
            if (better.isPresent()) {
                LOGGER.debug("Removing " + trial + " because " + better.get() + " makes it redundant");
                continue;
            }
            validated.add(trial);
        }
        return validated;
    }
}

