/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.explore.nlt.insights.detectors;

import com.ibm.bi.predict.dataaccess.DataAccessProvider;
import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.explore.ChartInsightsContext;
import com.ibm.bi.predict.explore.nlt.ChartInsight;
import com.ibm.bi.predict.explore.nlt.framework.Detector;
import com.ibm.bi.predict.explore.nlt.framework.Operation;
import com.ibm.bi.predict.explore.nlt.framework.Request;
import com.ibm.bi.predict.types.RoleType;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public abstract class InsightsDetector
implements Detector<ChartInsight> {
    protected static final List<Operation<ChartInsight>> NONE = Collections.emptyList();

    protected boolean isBasicInsightRequest(Request request) {
        if (!request.has(DataAccessProvider.class)) {
            return false;
        }
        MetaData metaData = request.get(DataAccessProvider.class).getMetaData();
        ChartInsightsContext params = request.get(ChartInsightsContext.class);
        List responseFields = IntStream.range(0, metaData.fieldCount()).filter(idx -> metaData.getFieldType(idx) == FieldType.NUMERICAL && params.hasRole(metaData.getFieldIdentifier(idx)) && params.getRole(metaData.getFieldIdentifier(idx)) == RoleType.RESPONSE).boxed().collect(Collectors.toList());
        return responseFields.size() == 1;
    }

    protected boolean isRoleExplanatoryGroupOrRepeat(ChartInsightsContext params, MetaData metaData, Integer index) {
        String fieldIdentifier = metaData.getFieldIdentifier(index.intValue());
        if (!params.hasRole(fieldIdentifier)) {
            return false;
        }
        RoleType fieldRole = params.getRole(fieldIdentifier);
        return fieldRole.equals((Object)RoleType.EXPLANATORY) || fieldRole.equals((Object)RoleType.GROUP) || fieldRole.equals((Object)RoleType.REPEAT);
    }

    protected List<Integer> getExplanatoryIndexes(MetaData metaData, ChartInsightsContext params) {
        return IntStream.range(0, metaData.fieldCount()).filter(idx -> this.isRoleExplanatoryGroupOrRepeat(params, metaData, idx)).boxed().collect(Collectors.toList());
    }

    protected List<Integer> getCategoricalExplanatoryIndexes(MetaData metaData, ChartInsightsContext params) {
        List<Integer> explanatoryIndexes = this.getExplanatoryIndexes(metaData, params);
        return explanatoryIndexes.stream().filter(idx -> metaData.getFieldType(idx.intValue()) == FieldType.CATEGORICAL || metaData.getFieldType(idx.intValue()) == FieldType.DATETIME).collect(Collectors.toList());
    }

    protected List<Integer> getExplanatoryIndexesWithMoreThanOneCategory(MetaData metaData, List<Integer> expFields) {
        return expFields.stream().filter(idx -> metaData.getFieldCategories(idx.intValue()) > 1).collect(Collectors.toList());
    }

    protected List<Integer> getResponseIndexes(MetaData metadata, ChartInsightsContext params) {
        return IntStream.range(0, metadata.fieldCount()).filter(idx -> params.getRole(metadata.getFieldIdentifier(idx)) == RoleType.RESPONSE).filter(idx -> metadata.getFieldType(idx) == FieldType.NUMERICAL).filter(idx -> this.isSuitableResponseField(idx, metadata)).boxed().collect(Collectors.toList());
    }

    protected boolean isSuitableResponseField(int idx, MetaData metadata) {
        return true;
    }

    protected boolean isChangedAggregationRequest(Request request, AggregationType fieldAggType, String responseID) {
        return fieldAggType != this.originalAggregation(request, responseID);
    }

    protected AggregationType originalAggregation(Request request, String fieldID) {
        MetaData originalMeta = request.original().get(DataAccessProvider.class).getMetaData();
        for (int i = 0; i < originalMeta.fieldCount(); ++i) {
            if (!fieldID.equals(originalMeta.getFieldIdentifier(i))) continue;
            return originalMeta.getFieldAggregation(i);
        }
        return AggregationType.NONE;
    }
}

